/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.messaging.v1;

import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpec;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.DeliverySpecFluentImpl;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpec;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpecBuilder;
import io.fabric8.knative.internal.eventing.pkg.apis.duck.v1.SubscriberSpecFluentImpl;
import io.fabric8.knative.messaging.v1.ChannelSpec;
import io.fabric8.knative.messaging.v1.ChannelSpecFluent;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpec;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecBuilder;
import io.fabric8.knative.messaging.v1.ChannelTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ChannelSpecFluentImpl<A extends ChannelSpecFluent<A>>
extends BaseFluent<A>
implements ChannelSpecFluent<A> {
    private ChannelTemplateSpecBuilder channelTemplate;
    private DeliverySpecBuilder delivery;
    private List<SubscriberSpecBuilder> subscribers;

    public ChannelSpecFluentImpl() {
    }

    public ChannelSpecFluentImpl(ChannelSpec instance) {
        this.withChannelTemplate(instance.getChannelTemplate());
        this.withDelivery(instance.getDelivery());
        this.withSubscribers(instance.getSubscribers());
    }

    @Override
    @Deprecated
    public ChannelTemplateSpec getChannelTemplate() {
        return this.channelTemplate != null ? this.channelTemplate.build() : null;
    }

    @Override
    public ChannelTemplateSpec buildChannelTemplate() {
        return this.channelTemplate != null ? this.channelTemplate.build() : null;
    }

    @Override
    public A withChannelTemplate(ChannelTemplateSpec channelTemplate) {
        this._visitables.get((Object)"channelTemplate").remove(this.channelTemplate);
        if (channelTemplate != null) {
            this.channelTemplate = new ChannelTemplateSpecBuilder(channelTemplate);
            this._visitables.get((Object)"channelTemplate").add(this.channelTemplate);
        }
        return (A)this;
    }

    @Override
    public Boolean hasChannelTemplate() {
        return this.channelTemplate != null;
    }

    @Override
    public ChannelSpecFluent.ChannelTemplateNested<A> withNewChannelTemplate() {
        return new ChannelTemplateNestedImpl();
    }

    @Override
    public ChannelSpecFluent.ChannelTemplateNested<A> withNewChannelTemplateLike(ChannelTemplateSpec item) {
        return new ChannelTemplateNestedImpl(item);
    }

    @Override
    public ChannelSpecFluent.ChannelTemplateNested<A> editChannelTemplate() {
        return this.withNewChannelTemplateLike(this.getChannelTemplate());
    }

    @Override
    public ChannelSpecFluent.ChannelTemplateNested<A> editOrNewChannelTemplate() {
        return this.withNewChannelTemplateLike(this.getChannelTemplate() != null ? this.getChannelTemplate() : new ChannelTemplateSpecBuilder().build());
    }

    @Override
    public ChannelSpecFluent.ChannelTemplateNested<A> editOrNewChannelTemplateLike(ChannelTemplateSpec item) {
        return this.withNewChannelTemplateLike(this.getChannelTemplate() != null ? this.getChannelTemplate() : item);
    }

    @Override
    @Deprecated
    public DeliverySpec getDelivery() {
        return this.delivery != null ? this.delivery.build() : null;
    }

    @Override
    public DeliverySpec buildDelivery() {
        return this.delivery != null ? this.delivery.build() : null;
    }

    @Override
    public A withDelivery(DeliverySpec delivery) {
        this._visitables.get((Object)"delivery").remove(this.delivery);
        if (delivery != null) {
            this.delivery = new DeliverySpecBuilder(delivery);
            this._visitables.get((Object)"delivery").add(this.delivery);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDelivery() {
        return this.delivery != null;
    }

    @Override
    public ChannelSpecFluent.DeliveryNested<A> withNewDelivery() {
        return new DeliveryNestedImpl();
    }

    @Override
    public ChannelSpecFluent.DeliveryNested<A> withNewDeliveryLike(DeliverySpec item) {
        return new DeliveryNestedImpl(item);
    }

    @Override
    public ChannelSpecFluent.DeliveryNested<A> editDelivery() {
        return this.withNewDeliveryLike(this.getDelivery());
    }

    @Override
    public ChannelSpecFluent.DeliveryNested<A> editOrNewDelivery() {
        return this.withNewDeliveryLike(this.getDelivery() != null ? this.getDelivery() : new DeliverySpecBuilder().build());
    }

    @Override
    public ChannelSpecFluent.DeliveryNested<A> editOrNewDeliveryLike(DeliverySpec item) {
        return this.withNewDeliveryLike(this.getDelivery() != null ? this.getDelivery() : item);
    }

    @Override
    public A addToSubscribers(int index, SubscriberSpec item) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList<SubscriberSpecBuilder>();
        }
        SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
        this._visitables.get((Object)"subscribers").add(index >= 0 ? index : this._visitables.get((Object)"subscribers").size(), builder);
        this.subscribers.add(index >= 0 ? index : this.subscribers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSubscribers(int index, SubscriberSpec item) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList<SubscriberSpecBuilder>();
        }
        SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"subscribers").size()) {
            this._visitables.get((Object)"subscribers").add(builder);
        } else {
            this._visitables.get((Object)"subscribers").set(index, builder);
        }
        if (index < 0 || index >= this.subscribers.size()) {
            this.subscribers.add(builder);
        } else {
            this.subscribers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSubscribers(SubscriberSpec ... items) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList<SubscriberSpecBuilder>();
        }
        for (SubscriberSpec item : items) {
            SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
            this._visitables.get((Object)"subscribers").add(builder);
            this.subscribers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubscribers(Collection<SubscriberSpec> items) {
        if (this.subscribers == null) {
            this.subscribers = new ArrayList<SubscriberSpecBuilder>();
        }
        for (SubscriberSpec item : items) {
            SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
            this._visitables.get((Object)"subscribers").add(builder);
            this.subscribers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubscribers(SubscriberSpec ... items) {
        for (SubscriberSpec item : items) {
            SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
            this._visitables.get((Object)"subscribers").remove(builder);
            if (this.subscribers == null) continue;
            this.subscribers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubscribers(Collection<SubscriberSpec> items) {
        for (SubscriberSpec item : items) {
            SubscriberSpecBuilder builder = new SubscriberSpecBuilder(item);
            this._visitables.get((Object)"subscribers").remove(builder);
            if (this.subscribers == null) continue;
            this.subscribers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSubscribers(Predicate<SubscriberSpecBuilder> predicate) {
        if (this.subscribers == null) {
            return (A)this;
        }
        Iterator<SubscriberSpecBuilder> each = this.subscribers.iterator();
        List visitables = this._visitables.get((Object)"subscribers");
        while (each.hasNext()) {
            SubscriberSpecBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SubscriberSpec> getSubscribers() {
        return ChannelSpecFluentImpl.build(this.subscribers);
    }

    @Override
    public List<SubscriberSpec> buildSubscribers() {
        return ChannelSpecFluentImpl.build(this.subscribers);
    }

    @Override
    public SubscriberSpec buildSubscriber(int index) {
        return this.subscribers.get(index).build();
    }

    @Override
    public SubscriberSpec buildFirstSubscriber() {
        return this.subscribers.get(0).build();
    }

    @Override
    public SubscriberSpec buildLastSubscriber() {
        return this.subscribers.get(this.subscribers.size() - 1).build();
    }

    @Override
    public SubscriberSpec buildMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
        for (SubscriberSpecBuilder item : this.subscribers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
        for (SubscriberSpecBuilder item : this.subscribers) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubscribers(List<SubscriberSpec> subscribers) {
        if (this.subscribers != null) {
            this._visitables.get((Object)"subscribers").removeAll(this.subscribers);
        }
        if (subscribers != null) {
            this.subscribers = new ArrayList<SubscriberSpecBuilder>();
            for (SubscriberSpec item : subscribers) {
                this.addToSubscribers(item);
            }
        } else {
            this.subscribers = null;
        }
        return (A)this;
    }

    @Override
    public A withSubscribers(SubscriberSpec ... subscribers) {
        if (this.subscribers != null) {
            this.subscribers.clear();
        }
        if (subscribers != null) {
            for (SubscriberSpec item : subscribers) {
                this.addToSubscribers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubscribers() {
        return this.subscribers != null && !this.subscribers.isEmpty();
    }

    @Override
    public ChannelSpecFluent.SubscribersNested<A> addNewSubscriber() {
        return new SubscribersNestedImpl();
    }

    @Override
    public ChannelSpecFluent.SubscribersNested<A> addNewSubscriberLike(SubscriberSpec item) {
        return new SubscribersNestedImpl(-1, item);
    }

    @Override
    public ChannelSpecFluent.SubscribersNested<A> setNewSubscriberLike(int index, SubscriberSpec item) {
        return new SubscribersNestedImpl(index, item);
    }

    @Override
    public ChannelSpecFluent.SubscribersNested<A> editSubscriber(int index) {
        if (this.subscribers.size() <= index) {
            throw new RuntimeException("Can't edit subscribers. Index exceeds size.");
        }
        return this.setNewSubscriberLike(index, this.buildSubscriber(index));
    }

    @Override
    public ChannelSpecFluent.SubscribersNested<A> editFirstSubscriber() {
        if (this.subscribers.size() == 0) {
            throw new RuntimeException("Can't edit first subscribers. The list is empty.");
        }
        return this.setNewSubscriberLike(0, this.buildSubscriber(0));
    }

    @Override
    public ChannelSpecFluent.SubscribersNested<A> editLastSubscriber() {
        int index = this.subscribers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subscribers. The list is empty.");
        }
        return this.setNewSubscriberLike(index, this.buildSubscriber(index));
    }

    @Override
    public ChannelSpecFluent.SubscribersNested<A> editMatchingSubscriber(Predicate<SubscriberSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subscribers.size(); ++i) {
            if (!predicate.apply((Object)this.subscribers.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subscribers. No match found.");
        }
        return this.setNewSubscriberLike(index, this.buildSubscriber(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChannelSpecFluentImpl that = (ChannelSpecFluentImpl)o;
        if (this.channelTemplate != null ? !this.channelTemplate.equals(that.channelTemplate) : that.channelTemplate != null) {
            return false;
        }
        if (this.delivery != null ? !this.delivery.equals(that.delivery) : that.delivery != null) {
            return false;
        }
        return !(this.subscribers != null ? !this.subscribers.equals(that.subscribers) : that.subscribers != null);
    }

    public int hashCode() {
        return Objects.hash(this.channelTemplate, this.delivery, this.subscribers, super.hashCode());
    }

    public class SubscribersNestedImpl<N>
    extends SubscriberSpecFluentImpl<ChannelSpecFluent.SubscribersNested<N>>
    implements ChannelSpecFluent.SubscribersNested<N>,
    Nested<N> {
        private final SubscriberSpecBuilder builder;
        private final int index;

        SubscribersNestedImpl(int index, SubscriberSpec item) {
            this.index = index;
            this.builder = new SubscriberSpecBuilder(this, item);
        }

        SubscribersNestedImpl() {
            this.index = -1;
            this.builder = new SubscriberSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ChannelSpecFluentImpl.this.setToSubscribers(this.index, this.builder.build());
        }

        @Override
        public N endSubscriber() {
            return this.and();
        }
    }

    public class DeliveryNestedImpl<N>
    extends DeliverySpecFluentImpl<ChannelSpecFluent.DeliveryNested<N>>
    implements ChannelSpecFluent.DeliveryNested<N>,
    Nested<N> {
        private final DeliverySpecBuilder builder;

        DeliveryNestedImpl(DeliverySpec item) {
            this.builder = new DeliverySpecBuilder(this, item);
        }

        DeliveryNestedImpl() {
            this.builder = new DeliverySpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ChannelSpecFluentImpl.this.withDelivery(this.builder.build());
        }

        @Override
        public N endDelivery() {
            return this.and();
        }
    }

    public class ChannelTemplateNestedImpl<N>
    extends ChannelTemplateSpecFluentImpl<ChannelSpecFluent.ChannelTemplateNested<N>>
    implements ChannelSpecFluent.ChannelTemplateNested<N>,
    Nested<N> {
        private final ChannelTemplateSpecBuilder builder;

        ChannelTemplateNestedImpl(ChannelTemplateSpec item) {
            this.builder = new ChannelTemplateSpecBuilder(this, item);
        }

        ChannelTemplateNestedImpl() {
            this.builder = new ChannelTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ChannelSpecFluentImpl.this.withChannelTemplate(this.builder.build());
        }

        @Override
        public N endChannelTemplate() {
            return this.and();
        }
    }
}

