/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.client.serving.v1beta1;

import io.fabric8.knative.client.serving.v1beta1.DefaultServingV1Beta1Client;
import io.fabric8.knative.client.serving.v1beta1.ServingV1Beta1Client;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import okhttp3.OkHttpClient;

public class ServingV1Beta1ExtensionAdapter
implements ExtensionAdapter<ServingV1Beta1Client> {
    static final ConcurrentMap<URL, Boolean> IS_KNATIVE = new ConcurrentHashMap<URL, Boolean>();
    static final ConcurrentMap<URL, Boolean> USES_KNATIVE_APIGROUPS = new ConcurrentHashMap<URL, Boolean>();

    public Class<ServingV1Beta1Client> getExtensionType() {
        return ServingV1Beta1Client.class;
    }

    public Boolean isAdaptable(Client client) {
        return this.isServingV1Beta1Available(client);
    }

    public ServingV1Beta1Client adapt(Client client) {
        return new DefaultServingV1Beta1Client((OkHttpClient)client.adapt(OkHttpClient.class), client.getConfiguration());
    }

    private boolean isServingV1Beta1Available(Client client) {
        List paths;
        URL masterUrl = client.getMasterUrl();
        if (IS_KNATIVE.containsKey(masterUrl)) {
            return (Boolean)IS_KNATIVE.get(masterUrl);
        }
        RootPaths rootPaths = client.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!path.endsWith("knative.dev") && !path.contains("knative.dev/")) continue;
                USES_KNATIVE_APIGROUPS.putIfAbsent(masterUrl, true);
                IS_KNATIVE.putIfAbsent(masterUrl, true);
                return true;
            }
        }
        IS_KNATIVE.putIfAbsent(masterUrl, false);
        return false;
    }
}

