/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.testing.jenkins;

import com.offbytwo.jenkins.JenkinsServer;
import io.fabric8.testing.jenkins.JenkinsAsserts;
import java.util.Map;
import java.util.Set;

public class JenkinsTestMain {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: [jenkinsServerUrl] [jobName]");
            return;
        }
        String jenkinsUrl = "http://jenkins.vagrant.f8/";
        String job = null;
        if (args.length > 0) {
            jenkinsUrl = args[0];
        }
        if (args.length > 1) {
            job = args[1];
        }
        try {
            JenkinsServer jenkins = JenkinsAsserts.createJenkinsServer(jenkinsUrl);
            Map jobs = jenkins.getJobs();
            Set entries = jobs.entrySet();
            for (Map.Entry entry : entries) {
                System.out.println("Job " + (String)entry.getKey() + " = " + entry.getValue());
            }
            if (job != null) {
                JenkinsAsserts.assertJobLastBuildIsSuccessful(jenkins, job);
            }
        }
        catch (Exception e) {
            JenkinsTestMain.logError(e.getMessage(), e);
        }
    }

    public static void logError(String message, Throwable e) {
        System.out.println("ERROR: " + message + e);
        e.printStackTrace();
        Throwable cause = e.getCause();
        if (cause != null && cause != e) {
            JenkinsTestMain.logError("Caused by: ", cause);
        }
    }
}

