/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.java.generator.maven.plugin;

import io.fabric8.java.generator.CRGeneratorRunner;
import io.fabric8.java.generator.Config;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class JavaGeneratorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="fabric8.java-generator.source", required=true)
    File source;
    @Parameter(property="fabric8.java-generator.target", defaultValue="${basedir}/target/generated-sources/java")
    File target;
    @Parameter(property="fabric8.java-generator.enum-uppercase", required=false)
    Boolean enumUppercase = null;
    @Parameter(property="fabric8.java-generator.prefix-strategy", required=false, readonly=true)
    Config.Prefix prefixStrategy = null;
    @Parameter(property="fabric8.java-generator.suffix-strategy", required=false)
    Config.Suffix suffixStrategy = null;
    @Parameter(property="fabric8.java-generator.always-preserve-unknown", required=false, readonly=true)
    Boolean alwaysPreserveUnknown = null;
    @Parameter(property="fabric8.java-generator.extra-annotations", required=false)
    Boolean extraAnnotations = null;
    @Parameter(property="fabric8.java-generator.code-structure", required=false, readonly=true)
    protected Config.CodeStructure codeStructure = null;

    public void execute() {
        Config config = new Config(this.enumUppercase, this.prefixStrategy, this.suffixStrategy, this.alwaysPreserveUnknown, this.extraAnnotations, this.codeStructure);
        CRGeneratorRunner runner = new CRGeneratorRunner(config);
        runner.run(this.source, this.target);
        this.project.addCompileSourceRoot(this.target.getAbsolutePath());
    }
}

