/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.NodeSelector;
import io.fabric8.kubernetes.api.model.NodeSelectorTerm;
import io.fabric8.kubernetes.api.model.NodeSelectorTermBuilder;
import io.fabric8.kubernetes.api.model.NodeSelectorTermFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NodeSelectorFluent<A extends NodeSelectorFluent<A>>
extends BaseFluent<A> {
    private ArrayList<NodeSelectorTermBuilder> nodeSelectorTerms = new ArrayList();
    private Map<String, Object> additionalProperties;

    public NodeSelectorFluent() {
    }

    public NodeSelectorFluent(NodeSelector instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NodeSelector instance) {
        NodeSelector nodeSelector = instance = instance != null ? instance : new NodeSelector();
        if (instance != null) {
            this.withNodeSelectorTerms(instance.getNodeSelectorTerms());
            this.withNodeSelectorTerms(instance.getNodeSelectorTerms());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToNodeSelectorTerms(int index, NodeSelectorTerm item) {
        if (this.nodeSelectorTerms == null) {
            this.nodeSelectorTerms = new ArrayList();
        }
        NodeSelectorTermBuilder builder = new NodeSelectorTermBuilder(item);
        if (index < 0 || index >= this.nodeSelectorTerms.size()) {
            this._visitables.get("nodeSelectorTerms").add(builder);
            this.nodeSelectorTerms.add(builder);
        } else {
            this._visitables.get("nodeSelectorTerms").add(index, builder);
            this.nodeSelectorTerms.add(index, builder);
        }
        return (A)this;
    }

    public A setToNodeSelectorTerms(int index, NodeSelectorTerm item) {
        if (this.nodeSelectorTerms == null) {
            this.nodeSelectorTerms = new ArrayList();
        }
        NodeSelectorTermBuilder builder = new NodeSelectorTermBuilder(item);
        if (index < 0 || index >= this.nodeSelectorTerms.size()) {
            this._visitables.get("nodeSelectorTerms").add(builder);
            this.nodeSelectorTerms.add(builder);
        } else {
            this._visitables.get("nodeSelectorTerms").set(index, builder);
            this.nodeSelectorTerms.set(index, builder);
        }
        return (A)this;
    }

    public A addToNodeSelectorTerms(NodeSelectorTerm ... items) {
        if (this.nodeSelectorTerms == null) {
            this.nodeSelectorTerms = new ArrayList();
        }
        for (NodeSelectorTerm item : items) {
            NodeSelectorTermBuilder builder = new NodeSelectorTermBuilder(item);
            this._visitables.get("nodeSelectorTerms").add(builder);
            this.nodeSelectorTerms.add(builder);
        }
        return (A)this;
    }

    public A addAllToNodeSelectorTerms(Collection<NodeSelectorTerm> items) {
        if (this.nodeSelectorTerms == null) {
            this.nodeSelectorTerms = new ArrayList();
        }
        for (NodeSelectorTerm item : items) {
            NodeSelectorTermBuilder builder = new NodeSelectorTermBuilder(item);
            this._visitables.get("nodeSelectorTerms").add(builder);
            this.nodeSelectorTerms.add(builder);
        }
        return (A)this;
    }

    public A removeFromNodeSelectorTerms(NodeSelectorTerm ... items) {
        if (this.nodeSelectorTerms == null) {
            return (A)this;
        }
        for (NodeSelectorTerm item : items) {
            NodeSelectorTermBuilder builder = new NodeSelectorTermBuilder(item);
            this._visitables.get("nodeSelectorTerms").remove(builder);
            this.nodeSelectorTerms.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromNodeSelectorTerms(Collection<NodeSelectorTerm> items) {
        if (this.nodeSelectorTerms == null) {
            return (A)this;
        }
        for (NodeSelectorTerm item : items) {
            NodeSelectorTermBuilder builder = new NodeSelectorTermBuilder(item);
            this._visitables.get("nodeSelectorTerms").remove(builder);
            this.nodeSelectorTerms.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromNodeSelectorTerms(Predicate<NodeSelectorTermBuilder> predicate) {
        if (this.nodeSelectorTerms == null) {
            return (A)this;
        }
        Iterator<NodeSelectorTermBuilder> each = this.nodeSelectorTerms.iterator();
        Object visitables = this._visitables.get("nodeSelectorTerms");
        while (each.hasNext()) {
            NodeSelectorTermBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NodeSelectorTerm> buildNodeSelectorTerms() {
        return this.nodeSelectorTerms != null ? NodeSelectorFluent.build(this.nodeSelectorTerms) : null;
    }

    public NodeSelectorTerm buildNodeSelectorTerm(int index) {
        return this.nodeSelectorTerms.get(index).build();
    }

    public NodeSelectorTerm buildFirstNodeSelectorTerm() {
        return this.nodeSelectorTerms.get(0).build();
    }

    public NodeSelectorTerm buildLastNodeSelectorTerm() {
        return this.nodeSelectorTerms.get(this.nodeSelectorTerms.size() - 1).build();
    }

    public NodeSelectorTerm buildMatchingNodeSelectorTerm(Predicate<NodeSelectorTermBuilder> predicate) {
        for (NodeSelectorTermBuilder item : this.nodeSelectorTerms) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingNodeSelectorTerm(Predicate<NodeSelectorTermBuilder> predicate) {
        for (NodeSelectorTermBuilder item : this.nodeSelectorTerms) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNodeSelectorTerms(List<NodeSelectorTerm> nodeSelectorTerms) {
        if (this.nodeSelectorTerms != null) {
            this._visitables.get("nodeSelectorTerms").clear();
        }
        if (nodeSelectorTerms != null) {
            this.nodeSelectorTerms = new ArrayList();
            for (NodeSelectorTerm item : nodeSelectorTerms) {
                this.addToNodeSelectorTerms(item);
            }
        } else {
            this.nodeSelectorTerms = null;
        }
        return (A)this;
    }

    public A withNodeSelectorTerms(NodeSelectorTerm ... nodeSelectorTerms) {
        if (this.nodeSelectorTerms != null) {
            this.nodeSelectorTerms.clear();
            this._visitables.remove("nodeSelectorTerms");
        }
        if (nodeSelectorTerms != null) {
            for (NodeSelectorTerm item : nodeSelectorTerms) {
                this.addToNodeSelectorTerms(item);
            }
        }
        return (A)this;
    }

    public boolean hasNodeSelectorTerms() {
        return this.nodeSelectorTerms != null && !this.nodeSelectorTerms.isEmpty();
    }

    public NodeSelectorTermsNested<A> addNewNodeSelectorTerm() {
        return new NodeSelectorTermsNested(-1, null);
    }

    public NodeSelectorTermsNested<A> addNewNodeSelectorTermLike(NodeSelectorTerm item) {
        return new NodeSelectorTermsNested(-1, item);
    }

    public NodeSelectorTermsNested<A> setNewNodeSelectorTermLike(int index, NodeSelectorTerm item) {
        return new NodeSelectorTermsNested(index, item);
    }

    public NodeSelectorTermsNested<A> editNodeSelectorTerm(int index) {
        if (this.nodeSelectorTerms.size() <= index) {
            throw new RuntimeException("Can't edit nodeSelectorTerms. Index exceeds size.");
        }
        return this.setNewNodeSelectorTermLike(index, this.buildNodeSelectorTerm(index));
    }

    public NodeSelectorTermsNested<A> editFirstNodeSelectorTerm() {
        if (this.nodeSelectorTerms.size() == 0) {
            throw new RuntimeException("Can't edit first nodeSelectorTerms. The list is empty.");
        }
        return this.setNewNodeSelectorTermLike(0, this.buildNodeSelectorTerm(0));
    }

    public NodeSelectorTermsNested<A> editLastNodeSelectorTerm() {
        int index = this.nodeSelectorTerms.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last nodeSelectorTerms. The list is empty.");
        }
        return this.setNewNodeSelectorTermLike(index, this.buildNodeSelectorTerm(index));
    }

    public NodeSelectorTermsNested<A> editMatchingNodeSelectorTerm(Predicate<NodeSelectorTermBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.nodeSelectorTerms.size(); ++i) {
            if (!predicate.test(this.nodeSelectorTerms.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching nodeSelectorTerms. No match found.");
        }
        return this.setNewNodeSelectorTermLike(index, this.buildNodeSelectorTerm(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeSelectorFluent that = (NodeSelectorFluent)o;
        if (!Objects.equals(this.nodeSelectorTerms, that.nodeSelectorTerms)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nodeSelectorTerms, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nodeSelectorTerms != null && !this.nodeSelectorTerms.isEmpty()) {
            sb.append("nodeSelectorTerms:");
            sb.append(this.nodeSelectorTerms + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NodeSelectorTermsNested<N>
    extends NodeSelectorTermFluent<NodeSelectorTermsNested<N>>
    implements Nested<N> {
        NodeSelectorTermBuilder builder;
        int index;

        NodeSelectorTermsNested(int index, NodeSelectorTerm item) {
            this.index = index;
            this.builder = new NodeSelectorTermBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NodeSelectorFluent.this.setToNodeSelectorTerms(this.index, this.builder.build());
        }

        public N endNodeSelectorTerm() {
            return this.and();
        }
    }
}

