/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.ClusterBuilder;
import io.fabric8.kubernetes.api.model.ClusterFluent;
import io.fabric8.kubernetes.api.model.NamedCluster;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NamedClusterFluent<A extends NamedClusterFluent<A>>
extends BaseFluent<A> {
    private ClusterBuilder cluster;
    private String name;
    private Map<String, Object> additionalProperties;

    public NamedClusterFluent() {
    }

    public NamedClusterFluent(NamedCluster instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NamedCluster instance) {
        NamedCluster namedCluster = instance = instance != null ? instance : new NamedCluster();
        if (instance != null) {
            this.withCluster(instance.getCluster());
            this.withName(instance.getName());
            this.withCluster(instance.getCluster());
            this.withName(instance.getName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Cluster buildCluster() {
        return this.cluster != null ? this.cluster.build() : null;
    }

    public A withCluster(Cluster cluster) {
        this._visitables.remove(this.cluster);
        if (cluster != null) {
            this.cluster = new ClusterBuilder(cluster);
            this._visitables.get("cluster").add(this.cluster);
        } else {
            this.cluster = null;
            this._visitables.get("cluster").remove(this.cluster);
        }
        return (A)this;
    }

    public boolean hasCluster() {
        return this.cluster != null;
    }

    public ClusterNested<A> withNewCluster() {
        return new ClusterNested(null);
    }

    public ClusterNested<A> withNewClusterLike(Cluster item) {
        return new ClusterNested(item);
    }

    public ClusterNested<A> editCluster() {
        return this.withNewClusterLike(Optional.ofNullable(this.buildCluster()).orElse(null));
    }

    public ClusterNested<A> editOrNewCluster() {
        return this.withNewClusterLike(Optional.ofNullable(this.buildCluster()).orElse(new ClusterBuilder().build()));
    }

    public ClusterNested<A> editOrNewClusterLike(Cluster item) {
        return this.withNewClusterLike(Optional.ofNullable(this.buildCluster()).orElse(item));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedClusterFluent that = (NamedClusterFluent)o;
        if (!Objects.equals(this.cluster, that.cluster)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cluster, this.name, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cluster != null) {
            sb.append("cluster:");
            sb.append(this.cluster + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClusterNested<N>
    extends ClusterFluent<ClusterNested<N>>
    implements Nested<N> {
        ClusterBuilder builder;

        ClusterNested(Cluster item) {
            this.builder = new ClusterBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NamedClusterFluent.this.withCluster(this.builder.build());
        }

        public N endCluster() {
            return this.and();
        }
    }
}

