/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.java.generator.nodes;

public class ValidationProperties {
    private final Double maximum;
    private final Double minimum;
    private final String pattern;

    private ValidationProperties(Double maximum, Double minimum, String pattern) {
        this.maximum = maximum;
        this.minimum = minimum;
        this.pattern = pattern;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public String getPattern() {
        return this.pattern;
    }

    public static final class Builder {
        private Double maximum;
        private Double minimum;
        private String pattern;

        private Builder() {
        }

        public static Builder getInstance() {
            return new Builder();
        }

        public Builder withMaximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public Builder withMinimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public Builder withPattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public ValidationProperties build() {
            return new ValidationProperties(this.maximum, this.minimum, this.pattern);
        }
    }
}

