/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRule;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerFluent;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NetworkPolicyEgressRuleFluent<A extends NetworkPolicyEgressRuleFluent<A>>
extends BaseFluent<A> {
    private ArrayList<NetworkPolicyPortBuilder> ports = new ArrayList();
    private ArrayList<NetworkPolicyPeerBuilder> to = new ArrayList();
    private Map<String, Object> additionalProperties;

    public NetworkPolicyEgressRuleFluent() {
    }

    public NetworkPolicyEgressRuleFluent(NetworkPolicyEgressRule instance) {
        NetworkPolicyEgressRule networkPolicyEgressRule = instance = instance != null ? instance : new NetworkPolicyEgressRule();
        if (instance != null) {
            this.withPorts(instance.getPorts());
            this.withTo(instance.getTo());
            this.withPorts(instance.getPorts());
            this.withTo(instance.getTo());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToPorts(int index, NetworkPolicyPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").add(index, builder);
            this.ports.add(index, builder);
        }
        return (A)this;
    }

    public A setToPorts(int index, NetworkPolicyPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    public A addToPorts(NetworkPolicyPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (NetworkPolicyPort item : items) {
            NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A addAllToPorts(Collection<NetworkPolicyPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (NetworkPolicyPort item : items) {
            NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A removeFromPorts(NetworkPolicyPort ... items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (NetworkPolicyPort item : items) {
            NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPorts(Collection<NetworkPolicyPort> items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (NetworkPolicyPort item : items) {
            NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPorts(Predicate<NetworkPolicyPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<NetworkPolicyPortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            NetworkPolicyPortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NetworkPolicyPort> buildPorts() {
        return this.ports != null ? NetworkPolicyEgressRuleFluent.build(this.ports) : null;
    }

    public NetworkPolicyPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    public NetworkPolicyPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    public NetworkPolicyPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    public NetworkPolicyPort buildMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate) {
        for (NetworkPolicyPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate) {
        for (NetworkPolicyPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPorts(List<NetworkPolicyPort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (NetworkPolicyPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    public A withPorts(NetworkPolicyPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove("ports");
        }
        if (ports != null) {
            for (NetworkPolicyPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public PortsNested<A> addNewPort() {
        return new PortsNested(-1, null);
    }

    public PortsNested<A> addNewPortLike(NetworkPolicyPort item) {
        return new PortsNested(-1, item);
    }

    public PortsNested<A> setNewPortLike(int index, NetworkPolicyPort item) {
        return new PortsNested(index, item);
    }

    public PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    public PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public A addToTo(int index, NetworkPolicyPeer item) {
        if (this.to == null) {
            this.to = new ArrayList();
        }
        NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
        if (index < 0 || index >= this.to.size()) {
            this._visitables.get("to").add(builder);
            this.to.add(builder);
        } else {
            this._visitables.get("to").add(index, builder);
            this.to.add(index, builder);
        }
        return (A)this;
    }

    public A setToTo(int index, NetworkPolicyPeer item) {
        if (this.to == null) {
            this.to = new ArrayList();
        }
        NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
        if (index < 0 || index >= this.to.size()) {
            this._visitables.get("to").add(builder);
            this.to.add(builder);
        } else {
            this._visitables.get("to").set(index, builder);
            this.to.set(index, builder);
        }
        return (A)this;
    }

    public A addToTo(NetworkPolicyPeer ... items) {
        if (this.to == null) {
            this.to = new ArrayList();
        }
        for (NetworkPolicyPeer item : items) {
            NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
            this._visitables.get("to").add(builder);
            this.to.add(builder);
        }
        return (A)this;
    }

    public A addAllToTo(Collection<NetworkPolicyPeer> items) {
        if (this.to == null) {
            this.to = new ArrayList();
        }
        for (NetworkPolicyPeer item : items) {
            NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
            this._visitables.get("to").add(builder);
            this.to.add(builder);
        }
        return (A)this;
    }

    public A removeFromTo(NetworkPolicyPeer ... items) {
        if (this.to == null) {
            return (A)this;
        }
        for (NetworkPolicyPeer item : items) {
            NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
            this._visitables.get("to").remove(builder);
            this.to.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTo(Collection<NetworkPolicyPeer> items) {
        if (this.to == null) {
            return (A)this;
        }
        for (NetworkPolicyPeer item : items) {
            NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
            this._visitables.get("to").remove(builder);
            this.to.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTo(Predicate<NetworkPolicyPeerBuilder> predicate) {
        if (this.to == null) {
            return (A)this;
        }
        Iterator<NetworkPolicyPeerBuilder> each = this.to.iterator();
        Object visitables = this._visitables.get("to");
        while (each.hasNext()) {
            NetworkPolicyPeerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NetworkPolicyPeer> buildTo() {
        return this.to != null ? NetworkPolicyEgressRuleFluent.build(this.to) : null;
    }

    public NetworkPolicyPeer buildTo(int index) {
        return this.to.get(index).build();
    }

    public NetworkPolicyPeer buildFirstTo() {
        return this.to.get(0).build();
    }

    public NetworkPolicyPeer buildLastTo() {
        return this.to.get(this.to.size() - 1).build();
    }

    public NetworkPolicyPeer buildMatchingTo(Predicate<NetworkPolicyPeerBuilder> predicate) {
        for (NetworkPolicyPeerBuilder item : this.to) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTo(Predicate<NetworkPolicyPeerBuilder> predicate) {
        for (NetworkPolicyPeerBuilder item : this.to) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTo(List<NetworkPolicyPeer> to) {
        if (this.to != null) {
            this._visitables.get("to").clear();
        }
        if (to != null) {
            this.to = new ArrayList();
            for (NetworkPolicyPeer item : to) {
                this.addToTo(item);
            }
        } else {
            this.to = null;
        }
        return (A)this;
    }

    public A withTo(NetworkPolicyPeer ... to) {
        if (this.to != null) {
            this.to.clear();
            this._visitables.remove("to");
        }
        if (to != null) {
            for (NetworkPolicyPeer item : to) {
                this.addToTo(item);
            }
        }
        return (A)this;
    }

    public boolean hasTo() {
        return this.to != null && !this.to.isEmpty();
    }

    public ToNested<A> addNewTo() {
        return new ToNested(-1, null);
    }

    public ToNested<A> addNewToLike(NetworkPolicyPeer item) {
        return new ToNested(-1, item);
    }

    public ToNested<A> setNewToLike(int index, NetworkPolicyPeer item) {
        return new ToNested(index, item);
    }

    public ToNested<A> editTo(int index) {
        if (this.to.size() <= index) {
            throw new RuntimeException("Can't edit to. Index exceeds size.");
        }
        return this.setNewToLike(index, this.buildTo(index));
    }

    public ToNested<A> editFirstTo() {
        if (this.to.size() == 0) {
            throw new RuntimeException("Can't edit first to. The list is empty.");
        }
        return this.setNewToLike(0, this.buildTo(0));
    }

    public ToNested<A> editLastTo() {
        int index = this.to.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last to. The list is empty.");
        }
        return this.setNewToLike(index, this.buildTo(index));
    }

    public ToNested<A> editMatchingTo(Predicate<NetworkPolicyPeerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.to.size(); ++i) {
            if (!predicate.test(this.to.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching to. No match found.");
        }
        return this.setNewToLike(index, this.buildTo(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicyEgressRuleFluent that = (NetworkPolicyEgressRuleFluent)o;
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        if (!Objects.equals(this.to, that.to)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ports, this.to, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports + ",");
        }
        if (this.to != null && !this.to.isEmpty()) {
            sb.append("to:");
            sb.append(this.to + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ToNested<N>
    extends NetworkPolicyPeerFluent<ToNested<N>>
    implements Nested<N> {
        NetworkPolicyPeerBuilder builder;
        int index;

        ToNested(int index, NetworkPolicyPeer item) {
            this.index = index;
            this.builder = new NetworkPolicyPeerBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyEgressRuleFluent.this.setToTo(this.index, this.builder.build());
        }

        public N endTo() {
            return this.and();
        }
    }

    public class PortsNested<N>
    extends NetworkPolicyPortFluent<PortsNested<N>>
    implements Nested<N> {
        NetworkPolicyPortBuilder builder;
        int index;

        PortsNested(int index, NetworkPolicyPort item) {
            this.index = index;
            this.builder = new NetworkPolicyPortBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyEgressRuleFluent.this.setToPorts(this.index, this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }
}

