/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v1.Scale;
import io.fabric8.kubernetes.api.model.autoscaling.v1.ScaleFluent;

public class ScaleBuilder
extends ScaleFluent<ScaleBuilder>
implements VisitableBuilder<Scale, ScaleBuilder> {
    ScaleFluent<?> fluent;
    Boolean validationEnabled;

    public ScaleBuilder() {
        this(false);
    }

    public ScaleBuilder(Boolean validationEnabled) {
        this(new Scale(), validationEnabled);
    }

    public ScaleBuilder(ScaleFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ScaleBuilder(ScaleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Scale(), validationEnabled);
    }

    public ScaleBuilder(ScaleFluent<?> fluent, Scale instance) {
        this(fluent, instance, false);
    }

    public ScaleBuilder(ScaleFluent<?> fluent, Scale instance, Boolean validationEnabled) {
        this.fluent = fluent;
        Scale scale = instance = instance != null ? instance : new Scale();
        if (instance != null) {
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withSpec(instance.getSpec());
            fluent.withStatus(instance.getStatus());
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withSpec(instance.getSpec());
            fluent.withStatus(instance.getStatus());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ScaleBuilder(Scale instance) {
        this(instance, (Boolean)false);
    }

    public ScaleBuilder(Scale instance, Boolean validationEnabled) {
        this.fluent = this;
        Scale scale = instance = instance != null ? instance : new Scale();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Scale build() {
        Scale buildable = new Scale(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.buildMetadata(), this.fluent.buildSpec(), this.fluent.buildStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

