/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.java.generator;

import java.util.HashMap;
import java.util.Map;

public class Config {
    private static final boolean DEFAULT_UPPERCASE_ENUM = true;
    private static final boolean DEFAULT_ADD_EXTRA_ANNOTATIONS = false;
    private static final boolean DEFAULT_ADD_GENERATED_ANNOTATIONS = true;
    private static final Map<String, String> DEFAULT_PACKAGE_OVERRIDES = new HashMap<String, String>();
    private Boolean uppercaseEnums = true;
    private Boolean objectExtraAnnotations = false;
    private Boolean generatedAnnotations = true;
    private Map<String, String> packageOverrides = DEFAULT_PACKAGE_OVERRIDES;

    public Config(Boolean uppercaseEnums, Boolean objectExtraAnnotations, Boolean generatedAnnotations, Map<String, String> packageOverrides) {
        if (uppercaseEnums != null) {
            this.uppercaseEnums = uppercaseEnums;
        }
        if (objectExtraAnnotations != null) {
            this.objectExtraAnnotations = objectExtraAnnotations;
        }
        if (generatedAnnotations != null) {
            this.generatedAnnotations = generatedAnnotations;
        }
        if (packageOverrides != null) {
            this.packageOverrides = packageOverrides;
        }
    }

    public boolean isUppercaseEnums() {
        return this.uppercaseEnums == null ? true : this.uppercaseEnums;
    }

    public boolean isObjectExtraAnnotations() {
        return this.objectExtraAnnotations == null ? false : this.objectExtraAnnotations;
    }

    public boolean isGeneratedAnnotations() {
        return this.generatedAnnotations == null ? true : this.generatedAnnotations;
    }

    public Map<String, String> getPackageOverrides() {
        return this.packageOverrides == null ? DEFAULT_PACKAGE_OVERRIDES : this.packageOverrides;
    }

    public static ConfigBuilder builder() {
        return new ConfigBuilder();
    }

    public ConfigBuilder toBuilder() {
        return new ConfigBuilder().uppercaseEnums(this.uppercaseEnums).objectExtraAnnotations(this.objectExtraAnnotations).generatedAnnotations(this.generatedAnnotations).packageOverrides(this.packageOverrides);
    }

    public Config() {
    }

    public static class ConfigBuilder {
        private Boolean uppercaseEnums;
        private Boolean objectExtraAnnotations;
        private Boolean generatedAnnotations;
        private Map<String, String> packageOverrides;

        ConfigBuilder() {
        }

        public ConfigBuilder uppercaseEnums(Boolean uppercaseEnums) {
            this.uppercaseEnums = uppercaseEnums;
            return this;
        }

        public ConfigBuilder objectExtraAnnotations(Boolean objectExtraAnnotations) {
            this.objectExtraAnnotations = objectExtraAnnotations;
            return this;
        }

        public ConfigBuilder generatedAnnotations(Boolean generatedAnnotations) {
            this.generatedAnnotations = generatedAnnotations;
            return this;
        }

        public ConfigBuilder packageOverrides(Map<String, String> packageOverrides) {
            this.packageOverrides = packageOverrides;
            return this;
        }

        public Config build() {
            return new Config(this.uppercaseEnums, this.objectExtraAnnotations, this.generatedAnnotations, this.packageOverrides);
        }

        public String toString() {
            return "Config.ConfigBuilder(uppercaseEnums=" + this.uppercaseEnums + ", objectExtraAnnotations=" + this.objectExtraAnnotations + ", generatedAnnotations=" + this.generatedAnnotations + ", packageOverrides=" + this.packageOverrides + ")";
        }
    }
}

