/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.extended.leaderelection.resourcelock;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseBuilder;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseFluent;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.LeaderElectionRecord;
import io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.ResourceLock;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;

public class LeaseLock
extends ResourceLock<Lease> {
    public LeaseLock(String leaseNamespace, String leaseName, String identity) {
        super(leaseNamespace, leaseName, identity);
    }

    public LeaseLock(ObjectMeta meta, String identity) {
        super(meta, identity);
    }

    @Override
    protected Class<Lease> getKind() {
        return Lease.class;
    }

    @Override
    protected Lease toResource(LeaderElectionRecord leaderElectionRecord, ObjectMeta meta) {
        return ((LeaseBuilder)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseFluent.SpecNested)((LeaseBuilder)new LeaseBuilder().withMetadata(meta)).withNewSpec().withHolderIdentity(leaderElectionRecord.getHolderIdentity())).withLeaseDurationSeconds((int)leaderElectionRecord.getLeaseDuration().get(ChronoUnit.SECONDS))).withAcquireTime(leaderElectionRecord.getAcquireTime())).withRenewTime(leaderElectionRecord.getRenewTime())).withLeaseTransitions(leaderElectionRecord.getLeaderTransitions())).endSpec()).build();
    }

    @Override
    protected LeaderElectionRecord toRecord(Lease resource) {
        return Optional.ofNullable(resource.getSpec()).map(spec -> new LeaderElectionRecord(spec.getHolderIdentity(), Duration.ofSeconds(spec.getLeaseDurationSeconds().intValue()), spec.getAcquireTime(), spec.getRenewTime(), Optional.ofNullable(spec.getLeaseTransitions()).orElse(0))).orElse(null);
    }
}

