/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.APIVersions;
import io.fabric8.kubernetes.api.model.ServerAddressByClientCIDR;
import io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRBuilder;
import io.fabric8.kubernetes.api.model.ServerAddressByClientCIDRFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class APIVersionsFluent<A extends APIVersionsFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private ArrayList<ServerAddressByClientCIDRBuilder> serverAddressByClientCIDRs = new ArrayList();
    private List<String> versions = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public APIVersionsFluent() {
    }

    public APIVersionsFluent(APIVersions instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(APIVersions instance) {
        APIVersions aPIVersions = instance = instance != null ? instance : new APIVersions();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs());
            this.withVersions(instance.getVersions());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public A addToServerAddressByClientCIDRs(int index, ServerAddressByClientCIDR item) {
        if (this.serverAddressByClientCIDRs == null) {
            this.serverAddressByClientCIDRs = new ArrayList();
        }
        ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);
        if (index < 0 || index >= this.serverAddressByClientCIDRs.size()) {
            this._visitables.get("serverAddressByClientCIDRs").add(builder);
            this.serverAddressByClientCIDRs.add(builder);
        } else {
            this._visitables.get("serverAddressByClientCIDRs").add(index, builder);
            this.serverAddressByClientCIDRs.add(index, builder);
        }
        return (A)this;
    }

    public A setToServerAddressByClientCIDRs(int index, ServerAddressByClientCIDR item) {
        if (this.serverAddressByClientCIDRs == null) {
            this.serverAddressByClientCIDRs = new ArrayList();
        }
        ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);
        if (index < 0 || index >= this.serverAddressByClientCIDRs.size()) {
            this._visitables.get("serverAddressByClientCIDRs").add(builder);
            this.serverAddressByClientCIDRs.add(builder);
        } else {
            this._visitables.get("serverAddressByClientCIDRs").set(index, builder);
            this.serverAddressByClientCIDRs.set(index, builder);
        }
        return (A)this;
    }

    public A addToServerAddressByClientCIDRs(ServerAddressByClientCIDR ... items) {
        if (this.serverAddressByClientCIDRs == null) {
            this.serverAddressByClientCIDRs = new ArrayList();
        }
        for (ServerAddressByClientCIDR item : items) {
            ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);
            this._visitables.get("serverAddressByClientCIDRs").add(builder);
            this.serverAddressByClientCIDRs.add(builder);
        }
        return (A)this;
    }

    public A addAllToServerAddressByClientCIDRs(Collection<ServerAddressByClientCIDR> items) {
        if (this.serverAddressByClientCIDRs == null) {
            this.serverAddressByClientCIDRs = new ArrayList();
        }
        for (ServerAddressByClientCIDR item : items) {
            ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);
            this._visitables.get("serverAddressByClientCIDRs").add(builder);
            this.serverAddressByClientCIDRs.add(builder);
        }
        return (A)this;
    }

    public A removeFromServerAddressByClientCIDRs(ServerAddressByClientCIDR ... items) {
        if (this.serverAddressByClientCIDRs == null) {
            return (A)this;
        }
        for (ServerAddressByClientCIDR item : items) {
            ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);
            this._visitables.get("serverAddressByClientCIDRs").remove(builder);
            this.serverAddressByClientCIDRs.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromServerAddressByClientCIDRs(Collection<ServerAddressByClientCIDR> items) {
        if (this.serverAddressByClientCIDRs == null) {
            return (A)this;
        }
        for (ServerAddressByClientCIDR item : items) {
            ServerAddressByClientCIDRBuilder builder = new ServerAddressByClientCIDRBuilder(item);
            this._visitables.get("serverAddressByClientCIDRs").remove(builder);
            this.serverAddressByClientCIDRs.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromServerAddressByClientCIDRs(Predicate<ServerAddressByClientCIDRBuilder> predicate) {
        if (this.serverAddressByClientCIDRs == null) {
            return (A)this;
        }
        Iterator<ServerAddressByClientCIDRBuilder> each = this.serverAddressByClientCIDRs.iterator();
        Object visitables = this._visitables.get("serverAddressByClientCIDRs");
        while (each.hasNext()) {
            ServerAddressByClientCIDRBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ServerAddressByClientCIDR> buildServerAddressByClientCIDRs() {
        return this.serverAddressByClientCIDRs != null ? APIVersionsFluent.build(this.serverAddressByClientCIDRs) : null;
    }

    public ServerAddressByClientCIDR buildServerAddressByClientCIDR(int index) {
        return this.serverAddressByClientCIDRs.get(index).build();
    }

    public ServerAddressByClientCIDR buildFirstServerAddressByClientCIDR() {
        return this.serverAddressByClientCIDRs.get(0).build();
    }

    public ServerAddressByClientCIDR buildLastServerAddressByClientCIDR() {
        return this.serverAddressByClientCIDRs.get(this.serverAddressByClientCIDRs.size() - 1).build();
    }

    public ServerAddressByClientCIDR buildMatchingServerAddressByClientCIDR(Predicate<ServerAddressByClientCIDRBuilder> predicate) {
        for (ServerAddressByClientCIDRBuilder item : this.serverAddressByClientCIDRs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingServerAddressByClientCIDR(Predicate<ServerAddressByClientCIDRBuilder> predicate) {
        for (ServerAddressByClientCIDRBuilder item : this.serverAddressByClientCIDRs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServerAddressByClientCIDRs(List<ServerAddressByClientCIDR> serverAddressByClientCIDRs) {
        if (this.serverAddressByClientCIDRs != null) {
            this._visitables.get("serverAddressByClientCIDRs").clear();
        }
        if (serverAddressByClientCIDRs != null) {
            this.serverAddressByClientCIDRs = new ArrayList();
            for (ServerAddressByClientCIDR item : serverAddressByClientCIDRs) {
                this.addToServerAddressByClientCIDRs(item);
            }
        } else {
            this.serverAddressByClientCIDRs = null;
        }
        return (A)this;
    }

    public A withServerAddressByClientCIDRs(ServerAddressByClientCIDR ... serverAddressByClientCIDRs) {
        if (this.serverAddressByClientCIDRs != null) {
            this.serverAddressByClientCIDRs.clear();
            this._visitables.remove("serverAddressByClientCIDRs");
        }
        if (serverAddressByClientCIDRs != null) {
            for (ServerAddressByClientCIDR item : serverAddressByClientCIDRs) {
                this.addToServerAddressByClientCIDRs(item);
            }
        }
        return (A)this;
    }

    public boolean hasServerAddressByClientCIDRs() {
        return this.serverAddressByClientCIDRs != null && !this.serverAddressByClientCIDRs.isEmpty();
    }

    public A addNewServerAddressByClientCIDR(String clientCIDR, String serverAddress) {
        return this.addToServerAddressByClientCIDRs(new ServerAddressByClientCIDR(clientCIDR, serverAddress));
    }

    public ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDR() {
        return new ServerAddressByClientCIDRsNested(-1, null);
    }

    public ServerAddressByClientCIDRsNested<A> addNewServerAddressByClientCIDRLike(ServerAddressByClientCIDR item) {
        return new ServerAddressByClientCIDRsNested(-1, item);
    }

    public ServerAddressByClientCIDRsNested<A> setNewServerAddressByClientCIDRLike(int index, ServerAddressByClientCIDR item) {
        return new ServerAddressByClientCIDRsNested(index, item);
    }

    public ServerAddressByClientCIDRsNested<A> editServerAddressByClientCIDR(int index) {
        if (this.serverAddressByClientCIDRs.size() <= index) {
            throw new RuntimeException("Can't edit serverAddressByClientCIDRs. Index exceeds size.");
        }
        return this.setNewServerAddressByClientCIDRLike(index, this.buildServerAddressByClientCIDR(index));
    }

    public ServerAddressByClientCIDRsNested<A> editFirstServerAddressByClientCIDR() {
        if (this.serverAddressByClientCIDRs.size() == 0) {
            throw new RuntimeException("Can't edit first serverAddressByClientCIDRs. The list is empty.");
        }
        return this.setNewServerAddressByClientCIDRLike(0, this.buildServerAddressByClientCIDR(0));
    }

    public ServerAddressByClientCIDRsNested<A> editLastServerAddressByClientCIDR() {
        int index = this.serverAddressByClientCIDRs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last serverAddressByClientCIDRs. The list is empty.");
        }
        return this.setNewServerAddressByClientCIDRLike(index, this.buildServerAddressByClientCIDR(index));
    }

    public ServerAddressByClientCIDRsNested<A> editMatchingServerAddressByClientCIDR(Predicate<ServerAddressByClientCIDRBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.serverAddressByClientCIDRs.size(); ++i) {
            if (!predicate.test(this.serverAddressByClientCIDRs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching serverAddressByClientCIDRs. No match found.");
        }
        return this.setNewServerAddressByClientCIDRLike(index, this.buildServerAddressByClientCIDR(index));
    }

    public A addToVersions(int index, String item) {
        if (this.versions == null) {
            this.versions = new ArrayList<String>();
        }
        this.versions.add(index, item);
        return (A)this;
    }

    public A setToVersions(int index, String item) {
        if (this.versions == null) {
            this.versions = new ArrayList<String>();
        }
        this.versions.set(index, item);
        return (A)this;
    }

    public A addToVersions(String ... items) {
        if (this.versions == null) {
            this.versions = new ArrayList<String>();
        }
        for (String item : items) {
            this.versions.add(item);
        }
        return (A)this;
    }

    public A addAllToVersions(Collection<String> items) {
        if (this.versions == null) {
            this.versions = new ArrayList<String>();
        }
        for (String item : items) {
            this.versions.add(item);
        }
        return (A)this;
    }

    public A removeFromVersions(String ... items) {
        if (this.versions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.versions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromVersions(Collection<String> items) {
        if (this.versions == null) {
            return (A)this;
        }
        for (String item : items) {
            this.versions.remove(item);
        }
        return (A)this;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public String getVersion(int index) {
        return this.versions.get(index);
    }

    public String getFirstVersion() {
        return this.versions.get(0);
    }

    public String getLastVersion() {
        return this.versions.get(this.versions.size() - 1);
    }

    public String getMatchingVersion(Predicate<String> predicate) {
        for (String item : this.versions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVersion(Predicate<String> predicate) {
        for (String item : this.versions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVersions(List<String> versions) {
        if (versions != null) {
            this.versions = new ArrayList<String>();
            for (String item : versions) {
                this.addToVersions(item);
            }
        } else {
            this.versions = null;
        }
        return (A)this;
    }

    public A withVersions(String ... versions) {
        if (this.versions != null) {
            this.versions.clear();
            this._visitables.remove("versions");
        }
        if (versions != null) {
            for (String item : versions) {
                this.addToVersions(item);
            }
        }
        return (A)this;
    }

    public boolean hasVersions() {
        return this.versions != null && !this.versions.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        APIVersionsFluent that = (APIVersionsFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.serverAddressByClientCIDRs, that.serverAddressByClientCIDRs)) {
            return false;
        }
        if (!Objects.equals(this.versions, that.versions)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.serverAddressByClientCIDRs, this.versions, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.serverAddressByClientCIDRs != null && !this.serverAddressByClientCIDRs.isEmpty()) {
            sb.append("serverAddressByClientCIDRs:");
            sb.append(this.serverAddressByClientCIDRs + ",");
        }
        if (this.versions != null && !this.versions.isEmpty()) {
            sb.append("versions:");
            sb.append(this.versions + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ServerAddressByClientCIDRsNested<N>
    extends ServerAddressByClientCIDRFluent<ServerAddressByClientCIDRsNested<N>>
    implements Nested<N> {
        ServerAddressByClientCIDRBuilder builder;
        int index;

        ServerAddressByClientCIDRsNested(int index, ServerAddressByClientCIDR item) {
            this.index = index;
            this.builder = new ServerAddressByClientCIDRBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)APIVersionsFluent.this.setToServerAddressByClientCIDRs(this.index, this.builder.build());
        }

        public N endServerAddressByClientCIDR() {
            return this.and();
        }
    }
}

