/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta1.ObjectMetricStatus;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ObjectMetricStatusFluent<A extends ObjectMetricStatusFluent<A>>
extends BaseFluent<A> {
    private Quantity averageValue;
    private Quantity currentValue;
    private String metricName;
    private LabelSelectorBuilder selector;
    private CrossVersionObjectReferenceBuilder target;
    private Map<String, Object> additionalProperties;

    public ObjectMetricStatusFluent() {
    }

    public ObjectMetricStatusFluent(ObjectMetricStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ObjectMetricStatus instance) {
        ObjectMetricStatus objectMetricStatus = instance = instance != null ? instance : new ObjectMetricStatus();
        if (instance != null) {
            this.withAverageValue(instance.getAverageValue());
            this.withCurrentValue(instance.getCurrentValue());
            this.withMetricName(instance.getMetricName());
            this.withSelector(instance.getSelector());
            this.withTarget(instance.getTarget());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Quantity getAverageValue() {
        return this.averageValue;
    }

    public A withAverageValue(Quantity averageValue) {
        this.averageValue = averageValue;
        return (A)this;
    }

    public boolean hasAverageValue() {
        return this.averageValue != null;
    }

    public A withNewAverageValue(String amount, String format) {
        return this.withAverageValue(new Quantity(amount, format));
    }

    public A withNewAverageValue(String amount) {
        return this.withAverageValue(new Quantity(amount));
    }

    public Quantity getCurrentValue() {
        return this.currentValue;
    }

    public A withCurrentValue(Quantity currentValue) {
        this.currentValue = currentValue;
        return (A)this;
    }

    public boolean hasCurrentValue() {
        return this.currentValue != null;
    }

    public A withNewCurrentValue(String amount, String format) {
        return this.withCurrentValue(new Quantity(amount, format));
    }

    public A withNewCurrentValue(String amount) {
        return this.withCurrentValue(new Quantity(amount));
    }

    public String getMetricName() {
        return this.metricName;
    }

    public A withMetricName(String metricName) {
        this.metricName = metricName;
        return (A)this;
    }

    public boolean hasMetricName() {
        return this.metricName != null;
    }

    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(LabelSelector selector) {
        this._visitables.remove("selector");
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get("selector").remove(this.selector);
        }
        return (A)this;
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public CrossVersionObjectReference buildTarget() {
        return this.target != null ? this.target.build() : null;
    }

    public A withTarget(CrossVersionObjectReference target) {
        this._visitables.remove("target");
        if (target != null) {
            this.target = new CrossVersionObjectReferenceBuilder(target);
            this._visitables.get("target").add(this.target);
        } else {
            this.target = null;
            this._visitables.get("target").remove(this.target);
        }
        return (A)this;
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public A withNewTarget(String apiVersion, String kind, String name) {
        return this.withTarget(new CrossVersionObjectReference(apiVersion, kind, name));
    }

    public TargetNested<A> withNewTarget() {
        return new TargetNested(null);
    }

    public TargetNested<A> withNewTargetLike(CrossVersionObjectReference item) {
        return new TargetNested(item);
    }

    public TargetNested<A> editTarget() {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(null));
    }

    public TargetNested<A> editOrNewTarget() {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(new CrossVersionObjectReferenceBuilder().build()));
    }

    public TargetNested<A> editOrNewTargetLike(CrossVersionObjectReference item) {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectMetricStatusFluent that = (ObjectMetricStatusFluent)o;
        if (!Objects.equals(this.averageValue, that.averageValue)) {
            return false;
        }
        if (!Objects.equals(this.currentValue, that.currentValue)) {
            return false;
        }
        if (!Objects.equals(this.metricName, that.metricName)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals(this.target, that.target)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.averageValue, this.currentValue, this.metricName, this.selector, this.target, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.averageValue != null) {
            sb.append("averageValue:");
            sb.append(this.averageValue + ",");
        }
        if (this.currentValue != null) {
            sb.append("currentValue:");
            sb.append(this.currentValue + ",");
        }
        if (this.metricName != null) {
            sb.append("metricName:");
            sb.append(this.metricName + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.target != null) {
            sb.append("target:");
            sb.append(this.target + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TargetNested<N>
    extends CrossVersionObjectReferenceFluent<TargetNested<N>>
    implements Nested<N> {
        CrossVersionObjectReferenceBuilder builder;

        TargetNested(CrossVersionObjectReference item) {
            this.builder = new CrossVersionObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ObjectMetricStatusFluent.this.withTarget(this.builder.build());
        }

        public N endTarget() {
            return this.and();
        }
    }

    public class SelectorNested<N>
    extends LabelSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ObjectMetricStatusFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }
}

