/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.impl.cache;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.informers.impl.cache.CacheImpl;
import io.fabric8.kubernetes.client.informers.impl.cache.ProcessorListener;
import io.fabric8.kubernetes.client.informers.impl.cache.SharedProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class ProcessorStore<T extends HasMetadata> {
    private CacheImpl<T> cache;
    private SharedProcessor<T> processor;
    private AtomicBoolean synced = new AtomicBoolean();
    private List<String> deferredAdd = new ArrayList<String>();

    public ProcessorStore(CacheImpl<T> cache, SharedProcessor<T> processor) {
        this.cache = cache;
        this.processor = processor;
    }

    public void add(T obj) {
        this.update(obj);
    }

    public void update(List<T> items) {
        items.stream().map(this::updateInternal).filter(Objects::nonNull).forEach(n -> this.processor.distribute((ProcessorListener.Notification<T>)n, false));
    }

    private ProcessorListener.Notification<T> updateInternal(T obj) {
        T oldObj = this.cache.put(obj);
        ProcessorListener.Notification notification = null;
        if (oldObj != null) {
            if (!Objects.equals(oldObj.getMetadata().getResourceVersion(), obj.getMetadata().getResourceVersion())) {
                notification = new ProcessorListener.UpdateNotification<T>(oldObj, obj);
            }
        } else if (this.synced.get() || !this.cache.isFullState()) {
            notification = new ProcessorListener.AddNotification<T>(obj);
        } else {
            this.deferredAdd.add(this.getKey(obj));
        }
        return notification;
    }

    public void update(T obj) {
        ProcessorListener.Notification<T> notification = this.updateInternal(obj);
        if (notification != null) {
            this.processor.distribute(notification, false);
        }
    }

    public void delete(T obj) {
        T oldObj = this.cache.remove(obj);
        if (oldObj != null) {
            this.processor.distribute(new ProcessorListener.DeleteNotification<T>(obj, false), false);
        }
    }

    public List<T> list() {
        return this.cache.list();
    }

    public List<String> listKeys() {
        return this.cache.listKeys();
    }

    public T get(T object) {
        return this.cache.get(object);
    }

    public T getByKey(String key) {
        return (T)this.cache.getByKey(key);
    }

    public void retainAll(Set<String> nextKeys, Consumer<Executor> cacheStateComplete) {
        if (this.synced.compareAndSet(false, true)) {
            this.deferredAdd.stream().map(this.cache::getByKey).filter(Objects::nonNull).forEach(v -> this.processor.distribute(new ProcessorListener.AddNotification<HasMetadata>((HasMetadata)v), false));
            this.deferredAdd.clear();
        }
        List<HasMetadata> current = this.cache.list();
        if (nextKeys.isEmpty() && current.isEmpty()) {
            this.processor.distribute(l -> l.getHandler().onNothing(), false);
        }
        current.forEach(v -> {
            String key = this.cache.getKey((HasMetadata)v);
            if (!nextKeys.contains(key)) {
                this.cache.remove((HasMetadata)v);
                this.processor.distribute(new ProcessorListener.DeleteNotification<HasMetadata>((HasMetadata)v, true), false);
            }
        });
        if (cacheStateComplete != null) {
            cacheStateComplete.accept(this.processor::execute);
        }
    }

    public String getKey(T obj) {
        return this.cache.getKey(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resync() {
        Object object = this.cache.getLockObject();
        synchronized (object) {
            this.cache.list().forEach(i -> this.processor.distribute(new ProcessorListener.UpdateNotification<HasMetadata>((HasMetadata)i, (HasMetadata)i), true));
        }
    }
}

