/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReference;
import io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReferenceBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.ServiceReferenceFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.WebhookClientConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class WebhookClientConfigFluent<A extends WebhookClientConfigFluent<A>>
extends BaseFluent<A> {
    private String caBundle;
    private ServiceReferenceBuilder service;
    private String url;
    private Map<String, Object> additionalProperties;

    public WebhookClientConfigFluent() {
    }

    public WebhookClientConfigFluent(WebhookClientConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(WebhookClientConfig instance) {
        WebhookClientConfig webhookClientConfig = instance = instance != null ? instance : new WebhookClientConfig();
        if (instance != null) {
            this.withCaBundle(instance.getCaBundle());
            this.withService(instance.getService());
            this.withUrl(instance.getUrl());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getCaBundle() {
        return this.caBundle;
    }

    public A withCaBundle(String caBundle) {
        this.caBundle = caBundle;
        return (A)this;
    }

    public boolean hasCaBundle() {
        return this.caBundle != null;
    }

    public ServiceReference buildService() {
        return this.service != null ? this.service.build() : null;
    }

    public A withService(ServiceReference service) {
        this._visitables.remove("service");
        if (service != null) {
            this.service = new ServiceReferenceBuilder(service);
            this._visitables.get("service").add(this.service);
        } else {
            this.service = null;
            this._visitables.get("service").remove(this.service);
        }
        return (A)this;
    }

    public boolean hasService() {
        return this.service != null;
    }

    public A withNewService(String name, String namespace, String path, Integer port) {
        return this.withService(new ServiceReference(name, namespace, path, port));
    }

    public ServiceNested<A> withNewService() {
        return new ServiceNested(null);
    }

    public ServiceNested<A> withNewServiceLike(ServiceReference item) {
        return new ServiceNested(item);
    }

    public ServiceNested<A> editService() {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(null));
    }

    public ServiceNested<A> editOrNewService() {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(new ServiceReferenceBuilder().build()));
    }

    public ServiceNested<A> editOrNewServiceLike(ServiceReference item) {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(item));
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebhookClientConfigFluent that = (WebhookClientConfigFluent)o;
        if (!Objects.equals(this.caBundle, that.caBundle)) {
            return false;
        }
        if (!Objects.equals(this.service, that.service)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.caBundle, this.service, this.url, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.caBundle != null) {
            sb.append("caBundle:");
            sb.append(this.caBundle + ",");
        }
        if (this.service != null) {
            sb.append("service:");
            sb.append(this.service + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ServiceNested<N>
    extends ServiceReferenceFluent<ServiceNested<N>>
    implements Nested<N> {
        ServiceReferenceBuilder builder;

        ServiceNested(ServiceReference item) {
            this.builder = new ServiceReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)WebhookClientConfigFluent.this.withService(this.builder.build());
        }

        public N endService() {
            return this.and();
        }
    }
}

