/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.examples.v1;

import io.fabric8.istio.api.examples.v1.ClientFactory;
import io.fabric8.istio.api.networking.v1.WorkloadEntryBuilder;
import io.fabric8.istio.api.networking.v1.WorkloadEntryFluent;
import io.fabric8.istio.api.networking.v1.WorkloadEntryList;
import io.fabric8.istio.client.IstioClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Collections;

public class WorkloadEntryExample {
    private static final String NAMESPACE = "test";

    public static void main(String[] args) {
        try {
            IstioClient client = ClientFactory.newClient(args);
            WorkloadEntryExample.createResource(client);
            System.exit(0);
        }
        catch (KubernetesClientException ex) {
            System.err.println("Failed with " + ex.getMessage());
            System.exit(1);
        }
    }

    public static void createResource(IstioClient client) {
        System.out.println("Creating a workload entry");
        ((Resource)((NonNamespaceOperation)client.v1().workloadEntries().inNamespace(NAMESPACE)).resource((Object)((WorkloadEntryBuilder)((WorkloadEntryFluent.SpecNested)((WorkloadEntryFluent.SpecNested)((WorkloadEntryBuilder)((WorkloadEntryFluent.MetadataNested)new WorkloadEntryBuilder().withNewMetadata().withName("details-svc")).endMetadata()).withNewSpec().withServiceAccount("details-legacy")).withLabels(Collections.singletonMap("app", "details-legacy"))).endSpec()).build())).create();
        System.out.println("Listing workload entry instances:");
        WorkloadEntryList list = (WorkloadEntryList)((NonNamespaceOperation)client.v1().workloadEntries().inNamespace(NAMESPACE)).list();
        list.getItems().forEach(b -> System.out.println(b.getMetadata().getName()));
        System.out.println("Done");
    }
}

