/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.examples.v1;

import io.fabric8.istio.api.api.security.v1beta1.PeerAuthenticationMutualTLSBuilder;
import io.fabric8.istio.api.api.security.v1beta1.PeerAuthenticationMutualTLSMode;
import io.fabric8.istio.api.api.type.v1beta1.WorkloadSelectorBuilder;
import io.fabric8.istio.api.examples.v1.ClientFactory;
import io.fabric8.istio.api.security.v1.PeerAuthenticationBuilder;
import io.fabric8.istio.api.security.v1.PeerAuthenticationFluent;
import io.fabric8.istio.api.security.v1.PeerAuthenticationList;
import io.fabric8.istio.client.IstioClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;

public class PeerAuthenticationExample {
    private static final String NAMESPACE = "test";

    public static void main(String[] args) {
        try {
            IstioClient client = ClientFactory.newClient(args);
            PeerAuthenticationExample.createResource(client);
            System.exit(0);
        }
        catch (KubernetesClientException ex) {
            System.err.println("Failed with " + ex.getMessage());
            System.exit(1);
        }
    }

    public static void createResource(IstioClient client) {
        System.out.println("Creating a PeerAuthentication entry");
        ((Resource)((NonNamespaceOperation)client.v1().peerAuthentications().inNamespace(NAMESPACE)).resource((Object)((PeerAuthenticationBuilder)((PeerAuthenticationFluent.SpecNested)((PeerAuthenticationFluent.SpecNested)((PeerAuthenticationBuilder)((PeerAuthenticationFluent.MetadataNested)new PeerAuthenticationBuilder().withNewMetadata().withName("details-svc")).endMetadata()).withNewSpec().withSelector(((WorkloadSelectorBuilder)new WorkloadSelectorBuilder().addToMatchLabels("app", "reviews")).build())).withMtls(((PeerAuthenticationMutualTLSBuilder)new PeerAuthenticationMutualTLSBuilder().withMode(PeerAuthenticationMutualTLSMode.DISABLE)).build())).endSpec()).build())).create();
        System.out.println("Listing workload entry instances:");
        PeerAuthenticationList list = (PeerAuthenticationList)((NonNamespaceOperation)client.v1().peerAuthentications().inNamespace(NAMESPACE)).list();
        list.getItems().forEach(b -> System.out.println(b.getMetadata().getName()));
        System.out.println("Done");
    }
}

