/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.examples.v1;

import io.fabric8.istio.api.api.networking.v1alpha3.PortBuilder;
import io.fabric8.istio.api.api.networking.v1alpha3.Server;
import io.fabric8.istio.api.api.networking.v1alpha3.ServerBuilder;
import io.fabric8.istio.api.api.networking.v1alpha3.ServerTLSSettingsBuilder;
import io.fabric8.istio.api.examples.v1.ClientFactory;
import io.fabric8.istio.api.networking.v1.GatewayBuilder;
import io.fabric8.istio.api.networking.v1.GatewayFluent;
import io.fabric8.istio.api.networking.v1.GatewayList;
import io.fabric8.istio.client.IstioClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.Collections;

public class GatewayExample {
    private static final String NAMESPACE = "test";

    public static void main(String[] args) {
        try {
            IstioClient client = ClientFactory.newClient(args);
            GatewayExample.createResource(client);
            System.exit(0);
        }
        catch (KubernetesClientException ex) {
            System.err.println("Failed with " + ex.getMessage());
            System.exit(1);
        }
    }

    public static void createResource(IstioClient client) {
        System.out.println("Creating a gateway");
        ((Resource)((NonNamespaceOperation)client.v1().gateways().inNamespace(NAMESPACE)).resource((Object)((GatewayBuilder)((GatewayFluent.SpecNested)((GatewayFluent.SpecNested)((GatewayBuilder)((GatewayFluent.MetadataNested)new GatewayBuilder().withNewMetadata().withName("my-gateway")).endMetadata()).withNewSpec().withSelector(Collections.singletonMap("app", "my-gateway-controller"))).withServers(new Server[]{((ServerBuilder)((ServerBuilder)((ServerBuilder)new ServerBuilder().withPort(((PortBuilder)((PortBuilder)((PortBuilder)new PortBuilder().withNumber(Long.valueOf(80L))).withProtocol("HTTP")).withName("http")).build())).withHosts(new String[]{"uk.bookinfo.com", "eu.bookinfo.com"})).withTls(((ServerTLSSettingsBuilder)new ServerTLSSettingsBuilder().withHttpsRedirect(Boolean.valueOf(true))).build())).build()})).endSpec()).build())).create();
        System.out.println("Listing gateway instances:");
        GatewayList list = (GatewayList)((NonNamespaceOperation)client.v1().gateways().inNamespace(NAMESPACE)).list();
        list.getItems().forEach(b -> System.out.println(b.getMetadata().getName()));
        System.out.println("Done");
    }
}

