/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.examples.v1beta1;

import io.fabric8.istio.api.examples.v1beta1.ClientFactory;
import io.fabric8.istio.api.security.v1beta1.PeerAuthenticationBuilder;
import io.fabric8.istio.api.security.v1beta1.PeerAuthenticationFluent;
import io.fabric8.istio.api.security.v1beta1.PeerAuthenticationList;
import io.fabric8.istio.api.security.v1beta1.PeerAuthenticationMutualTLS;
import io.fabric8.istio.api.security.v1beta1.PeerAuthenticationMutualTLSMode;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelectorBuilder;
import io.fabric8.istio.client.IstioClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;

public class PeerAuthenticationExample {
    private static final String NAMESPACE = "test";

    public static void main(String[] args) {
        try {
            IstioClient client = ClientFactory.newClient(args);
            PeerAuthenticationExample.createResource(client);
            System.exit(0);
        }
        catch (KubernetesClientException ex) {
            System.err.println("Failed with " + ex.getMessage());
            System.exit(1);
        }
    }

    public static void createResource(IstioClient client) {
        System.out.println("Creating a PeerAuthentication entry");
        ((NonNamespaceOperation)client.v1beta1().peerAuthentications().inNamespace(NAMESPACE)).create((Object)((PeerAuthenticationBuilder)((PeerAuthenticationFluent.SpecNested)((PeerAuthenticationFluent.SpecNested)((PeerAuthenticationBuilder)((PeerAuthenticationFluent.MetadataNested)new PeerAuthenticationBuilder().withNewMetadata().withName("details-svc")).endMetadata()).withNewSpec().withSelector(((WorkloadSelectorBuilder)new WorkloadSelectorBuilder().addToMatchLabels("app", "reviews")).build())).withMtls(new PeerAuthenticationMutualTLS(PeerAuthenticationMutualTLSMode.DISABLE))).endSpec()).build());
        System.out.println("Listing workload entry instances:");
        PeerAuthenticationList list = (PeerAuthenticationList)((NonNamespaceOperation)client.v1beta1().peerAuthentications().inNamespace(NAMESPACE)).list();
        list.getItems().forEach(b -> System.out.println(b.getMetadata().getName()));
        System.out.println("Done");
    }
}

