/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.examples.v1beta1;

import io.fabric8.istio.api.examples.v1beta1.ClientFactory;
import io.fabric8.istio.api.networking.v1beta1.IstioEgressListener;
import io.fabric8.istio.api.networking.v1beta1.IstioEgressListenerBuilder;
import io.fabric8.istio.api.networking.v1beta1.SidecarBuilder;
import io.fabric8.istio.api.networking.v1beta1.SidecarFluent;
import io.fabric8.istio.api.networking.v1beta1.SidecarList;
import io.fabric8.istio.client.IstioClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;

public class SidecarExample {
    private static final String NAMESPACE = "test";

    public static void main(String[] args) {
        try {
            IstioClient client = ClientFactory.newClient(args);
            SidecarExample.createResource(client);
            System.exit(0);
        }
        catch (KubernetesClientException ex) {
            System.err.println("Failed with " + ex.getMessage());
            System.exit(1);
        }
    }

    public static void createResource(IstioClient client) {
        System.out.println("Creating a sidecar");
        ((NonNamespaceOperation)client.v1beta1().sidecars().inNamespace(NAMESPACE)).create((Object)((SidecarBuilder)((SidecarFluent.SpecNested)((SidecarBuilder)((SidecarFluent.MetadataNested)new SidecarBuilder().withNewMetadata().withName("default")).endMetadata()).withNewSpec().withEgress(new IstioEgressListener[]{((IstioEgressListenerBuilder)new IstioEgressListenerBuilder().withHosts(new String[]{"./*", "istio-system/*"})).build()})).endSpec()).build());
        System.out.println("Listing sidecar instances:");
        SidecarList list = (SidecarList)((NonNamespaceOperation)client.v1beta1().sidecars().inNamespace(NAMESPACE)).list();
        list.getItems().forEach(b -> System.out.println(b.getMetadata().getName()));
        System.out.println("Done");
    }
}

