/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.hubot;

import io.fabric8.annotations.Protocol;
import io.fabric8.annotations.ServiceName;
import io.fabric8.hubot.HubotRestApi;
import io.fabric8.hubot.LoggingHubotRestApi;
import io.fabric8.hubot.NoopHubotRestApi;
import io.fabric8.utils.Strings;
import io.fabric8.utils.cxf.WebClients;
import java.util.List;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.deltaspike.core.api.config.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HubotNotifier {
    public static final String HUBOT_WEB_HOOK_SERVICE_NAME = "hubot-web-hook";
    public static final String DEFAULT_ROOM_EXPRESSION = "#fabric8_${namespace}";
    private static final transient Logger LOG = LoggerFactory.getLogger(HubotNotifier.class);
    @Inject
    @Protocol(value="http")
    @ServiceName(value="hubot-web-hook")
    private Instance<String> hubotUrlHolder;
    private final String username;
    private final String password;
    private final String roomExpression;
    private HubotRestApi api;
    private LoggingHubotRestApi logMessages = new LoggingHubotRestApi();
    private String hubotUrl;
    private boolean initalised;

    @Inject
    public HubotNotifier(@ConfigProperty(name="HUBOT_USERNAME", defaultValue="") String username, @ConfigProperty(name="HUBOT_PASSWORD", defaultValue="") String password, @ConfigProperty(name="HUBOT_BUILD_ROOM", defaultValue="#fabric8_${namespace}") String roomExpression) {
        this.username = username;
        this.password = password;
        this.roomExpression = roomExpression;
    }

    public HubotNotifier(String hubotUrl, String username, String password, String roomExpression) {
        this.hubotUrl = hubotUrl;
        this.username = username;
        this.password = password;
        this.roomExpression = roomExpression;
    }

    public String getHubotUrl() {
        if (!this.initalised) {
            this.initalised = true;
            if (this.hubotUrl == null && this.hubotUrlHolder != null) {
                this.hubotUrl = (String)this.hubotUrlHolder.get();
            }
            if (Strings.isNotBlank((String)this.hubotUrl)) {
                LOG.info("Starting HubotNotifier using address: " + this.hubotUrl);
            } else {
                LOG.warn("No kubernetes service found for hubot-web-hook so chat messages just going to logs instead");
            }
        }
        return this.hubotUrl;
    }

    public void notifyRoom(String room, String message) {
        this.logMessages.notify(room, message);
        try {
            this.getHubotRestApi().notify(room, message);
        }
        catch (Exception e) {
            LOG.error("Failed to notify hubot room: " + room + " with message: " + message + ". Reason: " + e, (Throwable)e);
        }
    }

    public void notifyBuild(String namespace, String buildConfig, String message) {
        String room = this.roomExpression.replace("${namespace}", namespace).replace("${buildConfig}", buildConfig);
        this.notifyRoom(room, message);
    }

    protected HubotRestApi getHubotRestApi() {
        if (this.api == null) {
            String url = this.getHubotUrl();
            this.api = Strings.isNotBlank((String)url) ? this.createWebClient(HubotRestApi.class, url) : new NoopHubotRestApi();
        }
        return this.api;
    }

    protected <T> T createWebClient(Class<T> clientType, String hubotUrl) {
        List providers = WebClients.createProviders();
        WebClient webClient = WebClient.create((String)hubotUrl, (List)providers);
        WebClients.disableSslChecks((WebClient)webClient);
        WebClients.configureUserAndPassword((WebClient)webClient, (String)this.username, (String)this.password);
        return (T)JAXRSClientFactory.fromClient((Client)webClient, clientType);
    }
}

