/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.support;

import io.fabric8.gateway.loadbalancer.ClientRequestFacade;
import io.fabric8.gateway.model.HttpProxyRule;
import io.fabric8.gateway.model.UriTemplateDefinition;
import io.fabric8.gateway.support.UriTemplate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MappingResult {
    private final Map<String, String> parameterNameValues;
    private final String[] requestUriPaths;
    private final HttpProxyRule proxyRule;

    public MappingResult(Map<String, String> parameterNameValues, String[] requestUriPaths, HttpProxyRule proxyRule) {
        this.requestUriPaths = requestUriPaths;
        this.proxyRule = proxyRule;
        this.parameterNameValues = Collections.unmodifiableMap(new HashMap<String, String>(parameterNameValues));
    }

    public String getDestinationUrl(ClientRequestFacade requestFacade) {
        UriTemplate uriTemplate;
        UriTemplateDefinition uriTemplateDefinition = this.proxyRule.chooseBackEndService(requestFacade);
        if (uriTemplateDefinition != null && (uriTemplate = uriTemplateDefinition.getUriTemplateObject()) != null) {
            return uriTemplate.bindByName(this.parameterNameValues);
        }
        return null;
    }

    public Map<String, String> getParameterNameValues() {
        return this.parameterNameValues;
    }

    public String[] getRequestUriPaths() {
        return this.requestUriPaths;
    }

    public HttpProxyRule getProxyRule() {
        return this.proxyRule;
    }
}

