/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.fabric.support.http;

import io.fabric8.gateway.ServiceDTO;
import io.fabric8.gateway.api.ServiceDetails;
import io.fabric8.gateway.api.apimanager.ApiManager;
import io.fabric8.gateway.api.handlers.http.HttpMappingRule;
import io.fabric8.gateway.fabric.http.HTTPGatewayConfig;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMappingKubeCache
implements Runnable {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpMappingKubeCache.class);
    private final ScheduledExecutorService serviceCacheExecutor = Executors.newSingleThreadScheduledExecutor();
    private KubernetesClient client;
    private final HttpMappingRule mappingRuleConfiguration;
    private final List<Map<String, String>> serviceSelectors;
    private List<String> contextPathsCache;
    private ApiManager apiManager;

    public HttpMappingKubeCache(HttpMappingRule mappingRuleConfiguration, List<Map<String, String>> serviceSelectors, ApiManager apiManager) {
        this.mappingRuleConfiguration = mappingRuleConfiguration;
        this.serviceSelectors = serviceSelectors;
        this.apiManager = apiManager;
    }

    public void init(HTTPGatewayConfig configuation) {
        String kubernetesMaster = configuation.getKubernetesMaster();
        KubernetesFactory factory = new KubernetesFactory(kubernetesMaster);
        this.contextPathsCache = new ArrayList<String>();
        this.client = new KubernetesClient(factory);
        this.serviceCacheExecutor.scheduleWithFixedDelay(this, 0L, 5L, TimeUnit.SECONDS);
    }

    public void destroy() {
        this.serviceCacheExecutor.shutdown();
    }

    protected static String paramValue(String paramValue) {
        return paramValue != null ? paramValue : "";
    }

    private boolean selectorMatch(Map<String, String> selector) {
        for (Map<String, String> serviceSelector : this.serviceSelectors) {
            boolean isMatch = true;
            for (String key : serviceSelector.keySet()) {
                if (selector.containsKey(key) && selector.get(key).equals(serviceSelector.get(key))) continue;
                isMatch = false;
                break;
            }
            if (!isMatch) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        this.refreshServices();
    }

    public void refreshServices() {
        ArrayList<String> currentCache = new ArrayList<String>();
        currentCache.addAll(this.contextPathsCache);
        try {
            ServiceList serviceList = this.client.getServices();
            for (Service service1 : serviceList.getItems()) {
                String[] apiManagerServiceInfo;
                Map selector = KubernetesHelper.getSelector((Service)service1);
                if (!this.selectorMatch(selector)) continue;
                String contextPath = KubernetesHelper.getId((Service)service1);
                if (this.apiManager != null && (apiManagerServiceInfo = this.apiManager.getService().getApiManagerServiceInfo(contextPath)) == null) {
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug("Service is not registered in the API Manager, and is therefore not yet available");
                    break;
                }
                ServiceDTO dto = new ServiceDTO();
                dto.setId(KubernetesHelper.getId((Service)service1));
                dto.setContainer((String)selector.get("container"));
                dto.setVersion((String)selector.get("version"));
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("id", HttpMappingKubeCache.paramValue(dto.getId()));
                params.put("container", HttpMappingKubeCache.paramValue(dto.getContainer()));
                params.put("version", HttpMappingKubeCache.paramValue(dto.getVersion()));
                String service = "http://localhost:" + KubernetesHelper.getPort((Service)service1) + "/" + KubernetesHelper.getId((Service)service1);
                List<String> services = Arrays.asList(service);
                if (!this.contextPathsCache.contains(contextPath)) {
                    LOG.info("Adding " + service);
                    this.contextPathsCache.add(contextPath);
                }
                this.mappingRuleConfiguration.updateMappingRules(false, contextPath, services, params, (ServiceDetails)dto);
                currentCache.remove(contextPath);
            }
            for (String contextPath : currentCache) {
                this.mappingRuleConfiguration.updateMappingRules(true, contextPath, null, null, null);
                LOG.info("Removing " + contextPath);
                this.contextPathsCache.remove(contextPath);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

