/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.fabric.http;

import io.fabric8.gateway.fabric.http.FabricHTTPGateway;
import io.fabric8.gateway.fabric.http.HTTPGatewayConfig;
import io.fabric8.gateway.fabric.support.http.HttpMappingKubeCache;
import io.fabric8.gateway.fabric.support.http.HttpMappingRuleBase;
import io.fabric8.gateway.loadbalancer.LoadBalancer;
import io.fabric8.gateway.loadbalancer.LoadBalancers;
import io.fabric8.zookeeper.internal.SimplePathTemplate;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class HttpMappingRuleConfiguration {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpMappingRuleConfiguration.class);
    @Inject
    private FabricHTTPGateway gateway;
    private List<Map<String, String>> serviceSelectors;
    private String uriTemplate;
    private String enabledVersion;
    private boolean reverseHeaders = true;
    private String loadBalancerType;
    private int stickyLoadBalancerCacheSize = 10000;
    private HttpMappingRuleBase httpMappingRuleBase;
    private HttpMappingKubeCache mappingTree;

    @PreDestroy
    void deactivate() {
        this.gateway.removeMappingRuleConfiguration(this.httpMappingRuleBase);
        this.httpMappingRuleBase = null;
        this.deactivateInternal();
    }

    List<Map<String, String>> getServiceSelectors() {
        return this.serviceSelectors;
    }

    void setServiceSelectors(List<Map<String, String>> serviceSelectors) {
        this.serviceSelectors = serviceSelectors;
    }

    String getEnabledVersion() {
        return this.enabledVersion;
    }

    void setEnabledVersion(String enabledVersion) {
        this.enabledVersion = enabledVersion;
    }

    String getUriTemplate() {
        return this.uriTemplate;
    }

    void setUriTemplate(String uriTemplate) {
        this.uriTemplate = uriTemplate;
    }

    String getLoadBalancerType() {
        return this.loadBalancerType;
    }

    void setLoadBalancerType(String loadBalancerType) {
        this.loadBalancerType = loadBalancerType;
    }

    public void configure(HTTPGatewayConfig httpGatewayConfig) throws Exception {
        this.serviceSelectors = httpGatewayConfig.getServiceSelectors();
        LOG.info("activating http mapping rule " + (String)httpGatewayConfig.get("GATEWAY_SERVICES_SELECTORS") + " on " + (String)httpGatewayConfig.get("HTTP_PORT"));
        this.loadBalancerType = httpGatewayConfig.getLoadBalancerType();
        this.uriTemplate = httpGatewayConfig.getUriTemplate();
        this.enabledVersion = httpGatewayConfig.getEnabledVersion();
        this.reverseHeaders = httpGatewayConfig.isReverseHeaders();
        LoadBalancer loadBalancer = LoadBalancers.createLoadBalancer((String)this.loadBalancerType, (int)this.stickyLoadBalancerCacheSize);
        LOG.info("activating http mapping selector: " + this.serviceSelectors + " with URI template: " + this.uriTemplate + " enabledVersion: " + this.enabledVersion + " with load balancer: " + loadBalancer);
        if (this.httpMappingRuleBase != null) {
            this.gateway.removeMappingRuleConfiguration(this.httpMappingRuleBase);
        }
        this.httpMappingRuleBase = new HttpMappingRuleBase(new SimplePathTemplate(this.uriTemplate), this.gateway.getGatewayVersion(), this.enabledVersion, loadBalancer, this.reverseHeaders);
        this.gateway.configure(httpGatewayConfig);
        this.mappingTree = new HttpMappingKubeCache(this.httpMappingRuleBase, this.serviceSelectors, this.gateway.getApiManager());
        this.mappingTree.init(httpGatewayConfig);
        this.gateway.addMappingRuleConfiguration(this.httpMappingRuleBase);
    }

    private void deactivateInternal() {
        if (this.mappingTree != null) {
            this.mappingTree.destroy();
            this.mappingTree = null;
        }
    }

    public String toString() {
        return "HttpMappingRuleConfiguration{serviceSelectors='" + this.serviceSelectors + '\'' + ", uriTemplate='" + this.uriTemplate + '\'' + ", enabledVersion='" + this.enabledVersion + '\'' + '}';
    }
}

