/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.fabric.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HTTPGatewayConfig
extends HashMap<String, String> {
    private static final long serialVersionUID = -7563354951392959816L;
    public static final String HOST = "HOST";
    public static final String HTTP_PORT = "HTTP_PORT";
    public static final String GATEWAY_URL = "GATEWAY_URL";
    public static final String ENABLE_INDEX = "ENABLE_INDEX";
    public static final String KUBERNETES_MASTER = "KUBERNETES_MASTER";
    public static final String SELECTORS = "GATEWAY_SERVICES_SELECTORS";
    public static final String URI_TEMPLATE = "URI_TEMPLATE";
    public static final String ENABLED_VERSION = "ENABLED_VERSION";
    public static final String IS_API_MANAGER_ENABLED = "IS_API_MANAGER_ENABLED";
    public static final String REVERSE_HEADERS = "REVERSE_HEADERS";
    public static final String LOAD_BALANCER = "LOAD_BALANCER";

    public int getPort() {
        return Integer.parseInt((String)this.get(HTTP_PORT));
    }

    public String getHost() {
        return (String)this.get(HOST);
    }

    public String getGatewayUrl() {
        return (String)this.get(GATEWAY_URL);
    }

    public boolean isIndexEnabled() {
        return Boolean.parseBoolean((String)this.get(ENABLE_INDEX));
    }

    public String getKubernetesMaster() {
        return (String)this.get(KUBERNETES_MASTER);
    }

    public List<Map<String, String>> getServiceSelectors() throws IOException {
        return HTTPGatewayConfig.parseSelectorConfig((String)this.get(SELECTORS));
    }

    public String getLoadBalancerType() {
        return (String)this.get(LOAD_BALANCER);
    }

    public String getUriTemplate() {
        return (String)this.get(URI_TEMPLATE);
    }

    public String getEnabledVersion() {
        return (String)this.get(ENABLED_VERSION);
    }

    public boolean isApiManagerEnabled() {
        return Boolean.parseBoolean((String)this.get(IS_API_MANAGER_ENABLED));
    }

    public boolean isReverseHeaders() {
        return Boolean.parseBoolean((String)this.get(REVERSE_HEADERS));
    }

    public static List<Map<String, String>> parseSelectorConfig(String selectorConfig) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        TypeReference<List<Map<String, String>>> typeRef = new TypeReference<List<Map<String, String>>>(){};
        return (List)mapper.readValue(selectorConfig, (TypeReference)typeRef);
    }
}

