/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.fabric.http;

import io.fabric8.gateway.api.CallDetailRecord;
import io.fabric8.gateway.api.apimanager.ApiManager;
import io.fabric8.gateway.api.apimanager.ApiManagerService;
import io.fabric8.gateway.api.handlers.http.HttpGateway;
import io.fabric8.gateway.api.handlers.http.HttpGatewayHandler;
import io.fabric8.gateway.api.handlers.http.HttpMappingRule;
import io.fabric8.gateway.api.handlers.http.IMappedServices;
import io.fabric8.gateway.fabric.http.FabricHTTPGatewayInfo;
import io.fabric8.gateway.fabric.http.HTTPGatewayConfig;
import io.fabric8.gateway.fabric.support.vertx.VertxService;
import io.fabric8.gateway.handlers.http.HttpGatewayServer;
import io.fabric8.utils.ShutdownTracker;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.management.MBeanServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;

@ApplicationScoped
public class FabricHTTPGateway
implements HttpGateway {
    private static final transient Logger LOG = LoggerFactory.getLogger(FabricHTTPGateway.class);
    @Inject
    VertxService vertxService;
    @Inject
    ApiManagerService apiManagerService;
    HTTPGatewayConfig gatewayConfig;
    private ApiManager apiManager;
    private HttpGatewayServer server;
    private MBeanServer mbeanServer;
    private Set<HttpMappingRule> mappingRuleConfigurations = new CopyOnWriteArraySet<HttpMappingRule>();
    ShutdownTracker shutdownTracker = new ShutdownTracker();
    private FabricHTTPGatewayInfo fabricHTTPGatewayInfoMBean;

    public void configure(HTTPGatewayConfig httpGatewayConfig) throws Exception {
        LOG.info("configuring the HTTP gateway");
        this.gatewayConfig = httpGatewayConfig;
        this.updateConfiguration();
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this.registerHttpGatewayMBeans();
    }

    @PreDestroy
    void deactivate() {
        this.deactivateInternal();
        this.unregisterHttpGatewayMBeans();
        this.gatewayConfig = null;
    }

    private void updateConfiguration() throws Exception {
        Vertx vertx = this.getVertx();
        this.apiManager = new ApiManager();
        HttpGatewayHandler requestHandler = null;
        if (this.gatewayConfig.isApiManagerEnabled()) {
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("vertx", this.getVertx());
            config.put("httpGateway", this);
            config.put("port", String.valueOf(this.gatewayConfig.getPort()));
            this.getApiManager().setService(this.apiManagerService);
            this.getApiManager().getService().init(config);
            requestHandler = this.getApiManager().getService().createApiManagerHttpGatewayHandler();
        } else {
            requestHandler = new HttpGatewayHandler(this.getVertx(), (HttpGateway)this);
        }
        this.server = new HttpGatewayServer(vertx, null, this.gatewayConfig.getPort(), (Handler)requestHandler);
        this.server.init();
    }

    private void deactivateInternal() {
        if (this.server != null) {
            this.server.destroy();
        }
    }

    public void addCallDetailRecord(CallDetailRecord cdr) {
        this.fabricHTTPGatewayInfoMBean.setLastCallDate(cdr.getCallDate().toString());
        this.fabricHTTPGatewayInfoMBean.registerCall(cdr.getCallTimeNanos());
        if (cdr.getError() != null) {
            this.fabricHTTPGatewayInfoMBean.setLastError(cdr.getError());
        }
    }

    public void addMappingRuleConfiguration(HttpMappingRule mappingRuleConfiguration) {
        this.mappingRuleConfigurations.add(mappingRuleConfiguration);
    }

    public void removeMappingRuleConfiguration(HttpMappingRule mappingRuleConfiguration) {
        this.mappingRuleConfigurations.remove(mappingRuleConfiguration);
    }

    public Map<String, IMappedServices> getMappedServices() {
        HashMap<String, IMappedServices> answer = new HashMap<String, IMappedServices>();
        for (HttpMappingRule mappingRuleConfiguration : this.mappingRuleConfigurations) {
            mappingRuleConfiguration.appendMappedServices(answer);
        }
        return answer;
    }

    public boolean isEnableIndex() {
        return this.gatewayConfig.isIndexEnabled();
    }

    public InetSocketAddress getLocalAddress() {
        return new InetSocketAddress(this.gatewayConfig.getHost() == null ? "0.0.0.0" : this.gatewayConfig.getHost(), this.gatewayConfig.getPort());
    }

    public String getGatewayUrl() {
        if (this.gatewayConfig.getGatewayUrl() != null) {
            return this.gatewayConfig.getGatewayUrl();
        }
        return "http://" + this.gatewayConfig.getHost() + ":" + this.gatewayConfig.getPort();
    }

    private Vertx getVertx() {
        return this.vertxService.getVertx();
    }

    String getGatewayVersion() {
        return "1.0";
    }

    int getPort() {
        return this.gatewayConfig.getPort();
    }

    String getHost() {
        return this.gatewayConfig.getHost();
    }

    private void registerHttpGatewayMBeans() {
        this.fabricHTTPGatewayInfoMBean = new FabricHTTPGatewayInfo(this);
        this.fabricHTTPGatewayInfoMBean.registerMBeanServer(this.shutdownTracker, this.mbeanServer);
    }

    private void unregisterHttpGatewayMBeans() {
        this.fabricHTTPGatewayInfoMBean.unregisterMBeanServer(this.mbeanServer);
    }

    public ApiManager getApiManager() {
        return this.apiManager;
    }
}

