/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.fabric.mq;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.api.gravia.IllegalStateAssertion;
import io.fabric8.api.jcip.GuardedBy;
import io.fabric8.common.util.Closeables;
import io.fabric8.gateway.ServiceDTO;
import io.fabric8.gateway.ServiceDetails;
import io.fabric8.gateway.ServiceMap;
import io.fabric8.gateway.handlers.tcp.TcpGateway;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GatewayServiceTreeCache {
    private static final transient Logger LOG = LoggerFactory.getLogger(GatewayServiceTreeCache.class);
    private final CuratorFramework curator;
    private final String zkPath;
    private final ServiceMap serviceMap;
    private final List<TcpGateway> gateways;
    private final ExecutorService treeCacheExecutor = Executors.newSingleThreadExecutor();
    private final AtomicBoolean active = new AtomicBoolean(false);
    private final ObjectMapper mapper = new ObjectMapper();
    private final PathChildrenCacheListener treeListener = new PathChildrenCacheListener(){

        public void childEvent(CuratorFramework curatorFramework, PathChildrenCacheEvent event) throws Exception {
            GatewayServiceTreeCache.this.treeCacheEvent(event);
        }
    };
    @GuardedBy(value="active")
    private volatile TreeCache treeCache;

    public GatewayServiceTreeCache(CuratorFramework curator, String zkPath, ServiceMap serviceMap, List<TcpGateway> gateways) {
        this.curator = curator;
        this.zkPath = zkPath;
        this.serviceMap = serviceMap;
        this.gateways = gateways;
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public String toString() {
        return "GatewayServiceTreeCache(zkPath: " + this.zkPath + " gateways: " + this.gateways + ")";
    }

    protected TreeCache getTreeCache() {
        IllegalStateAssertion.assertTrue((Boolean)this.active.get(), (String)"Gateway service cache not active");
        return this.treeCache;
    }

    public void init() throws Exception {
        if (this.active.compareAndSet(false, true)) {
            this.treeCache = new TreeCache(this.curator, this.zkPath, true, false, true, this.treeCacheExecutor);
            this.treeCache.start(TreeCache.StartMode.NORMAL);
            this.treeCache.getListenable().addListener((Object)this.treeListener);
            LOG.info("Started a group listener for " + this.zkPath);
            for (TcpGateway gateway : this.gateways) {
                gateway.init();
            }
        }
    }

    public void destroy() {
        if (this.active.compareAndSet(true, false)) {
            this.treeCache.getListenable().removeListener((Object)this.treeListener);
            Closeables.closeQuietly((Closeable)this.treeCache);
            this.treeCache = null;
            this.treeCacheExecutor.shutdownNow();
            for (TcpGateway gateway : this.gateways) {
                gateway.destroy();
            }
        }
    }

    protected void treeCacheEvent(PathChildrenCacheEvent event) {
        ChildData childData = event.getData();
        if (childData == null) {
            return;
        }
        String path = childData.getPath();
        PathChildrenCacheEvent.Type type = event.getType();
        byte[] data = childData.getData();
        if (data == null || data.length == 0 || path == null) {
            return;
        }
        if (path.startsWith(this.zkPath)) {
            path = path.substring(this.zkPath.length());
        }
        boolean remove = false;
        switch (type) {
            case CHILD_ADDED: 
            case CHILD_UPDATED: {
                break;
            }
            case CHILD_REMOVED: {
                remove = true;
                break;
            }
            default: {
                return;
            }
        }
        ServiceDTO dto = null;
        try {
            dto = (ServiceDTO)this.mapper.readValue(data, ServiceDTO.class);
            this.expandPropertyResolvers(dto);
            if (remove) {
                this.serviceMap.serviceRemoved(path, (ServiceDetails)dto);
            } else {
                this.serviceMap.serviceUpdated(path, (ServiceDetails)dto);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to parse the JSON: " + new String(data) + ". Reason: " + e, (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOG.warn("Failed to update URI for dto: " + dto + ", .Reason: " + e, (Throwable)e);
        }
    }

    protected void expandPropertyResolvers(ServiceDTO dto) throws URISyntaxException {
        List services = dto.getServices();
        ArrayList<String> newList = new ArrayList<String>(services.size());
        for (String service : services) {
            String expanded = ZooKeeperUtils.getSubstitutedData((CuratorFramework)this.curator, (String)service);
            newList.add(expanded);
        }
        dto.setServices(newList);
    }
}

