/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.fabric.detecting;

import io.fabric8.api.FabricService;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.common.util.JMXUtils;
import io.fabric8.common.util.ShutdownTracker;
import io.fabric8.common.util.Strings;
import io.fabric8.gateway.ServiceMap;
import io.fabric8.gateway.fabric.detecting.FabricDetectingGatewayService;
import io.fabric8.gateway.fabric.detecting.GatewayServiceTreeCache;
import io.fabric8.gateway.fabric.http.FabricHTTPGateway;
import io.fabric8.gateway.fabric.support.vertx.VertxService;
import io.fabric8.gateway.handlers.detecting.DetectingGateway;
import io.fabric8.gateway.handlers.detecting.protocol.amqp.AmqpProtocol;
import io.fabric8.gateway.handlers.detecting.protocol.http.HttpProtocol;
import io.fabric8.gateway.handlers.detecting.protocol.mqtt.MqttProtocol;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.OpenwireProtocol;
import io.fabric8.gateway.handlers.detecting.protocol.ssl.SslConfig;
import io.fabric8.gateway.handlers.detecting.protocol.ssl.SslProtocol;
import io.fabric8.gateway.handlers.detecting.protocol.stomp.StompProtocol;
import io.fabric8.gateway.loadbalancer.LoadBalancer;
import io.fabric8.gateway.loadbalancer.LoadBalancers;
import io.fabric8.internal.Objects;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.gateway.detecting", immediate=true, metatype=true, policy=ConfigurationPolicy.REQUIRE, label="Fabric8 Detecting Gateway", description="Provides a discovery and load balancing gateway between clients using various messaging protocols and the available message brokers in the fabric")
@Service(value={FabricDetectingGatewayService.class})
public class FabricDetectingGateway
extends AbstractComponent
implements FabricDetectingGatewayService {
    private static final transient Logger LOG = LoggerFactory.getLogger(FabricDetectingGateway.class);
    @Reference
    private MBeanServer mbeanServer;
    @Reference
    private Configurer configurer;
    @Reference(referenceInterface=VertxService.class, cardinality=ReferenceCardinality.MANDATORY_UNARY, bind="setVertxService", unbind="unsetVertxService")
    private VertxService vertxService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, bind="setFabricService", unbind="unsetFabricService")
    private FabricService fabricService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, bind="setCurator", unbind="unsetCurator")
    private CuratorFramework curator;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, bind="setHttpGateway", unbind="unsetHttpGateway", policy=ReferencePolicy.DYNAMIC)
    private FabricHTTPGateway httpGateway;
    @Property(name="zooKeeperPath", value={"/fabric/registry/clusters/amq"}, label="ZooKeeper path", description="The path in ZooKeeper which is monitored to discover the available message brokers")
    private String zooKeeperPath;
    @Property(name="address", label="Bind Address", description="The IP address or host name to bind when to listen for new connections")
    private String address;
    @Property(name="defaultVirtualHost", label="Default Virtual Host", description="The virtual host name to assume a client is trying to connect to when the client protocol does not specify a valid virtual hostname.")
    private String defaultVirtualHost;
    @Property(name="port", intValue={61616}, label="Bind Port", description="The IP port to bind when to listen for new connections")
    private int port = 61616;
    @Property(name="openWireEnabled", boolValue={true}, label="OpenWire enabled", description="Enable or disable the OpenWire transport protocol")
    private boolean openWireEnabled = true;
    @Property(name="stompEnabled", boolValue={true}, label="STOMP enabled", description="Enable or disable the STOMP transport protocol")
    private boolean stompEnabled = true;
    @Property(name="amqpEnabled", boolValue={true}, label="AMQP enabled", description="Enable or disable the AMQP transport protocol")
    private boolean amqpEnabled = true;
    @Property(name="mqttEnabled", boolValue={true}, label="MQTT enabled", description="Enable or disable the MQTT transport protocol")
    private boolean mqttEnabled = true;
    @Property(name="httpEnabled", boolValue={true}, label="HTTP enabled", description="Enable or disable the HTTP protocol detection")
    private boolean httpEnabled = true;
    @Property(name="sslEnabled", boolValue={false}, label="SSL enabled", description="Enable or disable the SSL protocol detection")
    private boolean sslEnabled = false;
    @Property(name="loadBalancerType", value={"roundrobin"}, options={@PropertyOption(name="random", value="Random"), @PropertyOption(name="roundrobin", value="Round Robin"), @PropertyOption(name="sticky", value="Sticky")}, label="Load Balancer", description="The kind of load balancing strategy to use when multiple endpoints can service the client conneciton")
    private String loadBalancerType;
    @Property(name="stickyLoadBalancerCacheSize", intValue={10000}, label="Sticky Load Balancer Cache Size", description="The number of unique client keys to cache for the sticky load balancer (using an LRU caching algorithm)")
    private int stickyLoadBalancerCacheSize = 10000;
    @Property(name="sslProtocol", value={"TLS"}, label="SSL Protocol", description="Example: SSL, TLS, TLSv1, TLSv2 etc.")
    private String sslProtocol;
    @Property(name="sslStoreType", value={"JKS"}, label="SSL Store Type ", description="The type of store that the keys stored within")
    private String sslStoreType;
    @Property(name="sslAlgorithm", value={"SunX509"}, label="SSL Certificate Algorithm", description="The encryption algorithm of the certificates")
    private String sslAlgorithm;
    @Property(name="trustStoreURL", label="SSL Trust Store URL", description="The trust store holds the public certificates of clients that will be trusted to SSL connect to the server.  If not set, the key store will be used.")
    private URL trustStoreURL;
    @Property(name="trustStorePassword", label="SSL Trust Store Password", description="The password used to open the trust store")
    private String trustStorePassword;
    @Property(name="keyStoreURL", label="SSL Key Store URL", description="The key store holds the private certificate of the server.")
    private URL keyStoreURL;
    @Property(name="keyStorePassword", label="SSL Key Store Password", description="The password used to open the key store")
    private String keyStorePassword;
    @Property(name="keyAlias", label="SSL Private Key Alias", description="Alias of the private key to use for SSL connections")
    private String keyAlias;
    @Property(name="keyPassword", label="SSL Private Key Password", description="The password used to access the SSL private key")
    private String keyPassword;
    @Property(name="enabledCipherSuites", label="SSL Cipher Suites Enabled", description="Comma separated list of cipher suites to enable on the SSL sessions.")
    String enabledCipherSuites;
    @Property(name="disabledCypherSuites", label="SSL Cipher Suites Disabled", description="Comma separated list of cipher suites to disable on the SSL sessions.")
    String disabledCypherSuites;
    private DetectingGateway detectingGateway;
    private GatewayServiceTreeCache cache;
    private ServiceMap serviceMap = new ServiceMap();
    private final ShutdownTracker shutdownTacker = new ShutdownTracker();

    @Activate
    void activate(Map<String, ?> configuration) throws Exception {
        this.configurer.configure(configuration, (Object)this, new String[0]);
        Objects.notNull((Object)this.getVertxService(), (String)"vertxService");
        Objects.notNull((Object)this.getZooKeeperPath(), (String)"zooKeeperPath");
        this.activateComponent();
        this.detectingGateway = this.createDetectingGateway();
        if (this.detectingGateway != null) {
            if (this.httpGateway != null) {
                this.detectingGateway.setHttpGateway(this.httpGateway.getLocalAddress());
            }
            this.cache = new GatewayServiceTreeCache(this.getCurator(), this.getZooKeeperPath(), this.serviceMap);
            this.cache.init();
            this.detectingGateway.init();
        }
        JMXUtils.registerMBean((Object)this.shutdownTacker.mbeanProxy((Object)this.detectingGateway), (MBeanServer)this.mbeanServer, (ObjectName)new ObjectName("io.fabric8.gateway:type=DetectingGateway"));
    }

    @Deactivate
    void deactivate() throws Exception {
        JMXUtils.unregisterMBean((MBeanServer)this.mbeanServer, (ObjectName)new ObjectName("io.fabric8.gateway:type=DetectingGateway"));
        this.deactivateComponent();
        if (this.detectingGateway != null) {
            this.cache.destroy();
            this.detectingGateway.destroy();
        }
        this.shutdownTacker.stop();
    }

    protected DetectingGateway createDetectingGateway() {
        DetectingGateway gateway = new DetectingGateway();
        ArrayList<Object> protocols = new ArrayList<Object>();
        if (this.isStompEnabled()) {
            protocols.add(new StompProtocol());
        }
        if (this.isMqttEnabled()) {
            protocols.add(new MqttProtocol());
        }
        if (this.isAmqpEnabled()) {
            protocols.add(new AmqpProtocol());
        }
        if (this.isOpenWireEnabled()) {
            protocols.add(new OpenwireProtocol());
        }
        if (this.isHttpEnabled()) {
            protocols.add(new HttpProtocol());
        }
        if (this.isSslEnabled()) {
            SslConfig sslConfig = new SslConfig();
            if (Strings.isNotBlank((String)this.sslAlgorithm)) {
                sslConfig.setAlgorithm(this.sslAlgorithm);
            }
            if (Strings.isNotBlank((String)this.keyAlias)) {
                sslConfig.setKeyAlias(this.keyAlias);
            }
            if (Strings.isNotBlank((String)this.keyPassword)) {
                sslConfig.setKeyPassword(this.keyPassword);
            }
            if (Strings.isNotBlank((String)this.keyStorePassword)) {
                sslConfig.setKeyStorePassword(this.keyStorePassword);
            }
            if (this.keyStoreURL != null) {
                sslConfig.setKeyStoreURL(this.keyStoreURL);
            }
            if (Strings.isNotBlank((String)this.sslProtocol)) {
                sslConfig.setProtocol(this.sslProtocol);
            }
            if (Strings.isNotBlank((String)this.sslStoreType)) {
                sslConfig.setStoreType(this.sslStoreType);
            }
            if (Strings.isNotBlank((String)this.trustStorePassword)) {
                sslConfig.setTrustStorePassword(this.trustStorePassword);
            }
            if (this.trustStoreURL != null) {
                sslConfig.setTrustStoreURL(this.trustStoreURL);
            }
            if (Strings.isNotBlank((String)this.enabledCipherSuites)) {
                sslConfig.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            if (Strings.isNotBlank((String)this.disabledCypherSuites)) {
                sslConfig.setDisabledCypherSuites(this.disabledCypherSuites);
            }
            gateway.setSslConfig(sslConfig);
            protocols.add(new SslProtocol());
        }
        if (protocols.isEmpty()) {
            return null;
        }
        VertxService vertxService = this.getVertxService();
        LoadBalancer serviceLoadBalancer = LoadBalancers.createLoadBalancer((String)this.loadBalancerType, (int)this.stickyLoadBalancerCacheSize);
        gateway.setVertx(vertxService.getVertx());
        gateway.setPort(this.port);
        gateway.setServiceMap(this.serviceMap);
        gateway.setProtocols(protocols);
        gateway.setShutdownTacker(this.shutdownTacker);
        gateway.setServiceLoadBalancer(serviceLoadBalancer);
        gateway.setDefaultVirtualHost(this.defaultVirtualHost);
        return gateway;
    }

    public VertxService getVertxService() {
        return this.vertxService;
    }

    public void setVertxService(VertxService vertxService) {
        this.vertxService = vertxService;
    }

    public void unsetVertxService(VertxService vertxService) {
        this.vertxService = null;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public void setCurator(CuratorFramework curator) {
        this.curator = curator;
    }

    public void unsetCurator(CuratorFramework curator) {
        this.curator = null;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public void unsetFabricService(FabricService fabricService) {
        this.fabricService = null;
    }

    public String getZooKeeperPath() {
        return this.zooKeeperPath;
    }

    public void setZooKeeperPath(String zooKeeperPath) {
        this.zooKeeperPath = zooKeeperPath;
    }

    public boolean isOpenWireEnabled() {
        return this.openWireEnabled;
    }

    public void setOpenWireEnabled(boolean openWireEnabled) {
        this.openWireEnabled = openWireEnabled;
    }

    public boolean isStompEnabled() {
        return this.stompEnabled;
    }

    public void setStompEnabled(boolean stompEnabled) {
        this.stompEnabled = stompEnabled;
    }

    public boolean isAmqpEnabled() {
        return this.amqpEnabled;
    }

    public void setAmqpEnabled(boolean amqpEnabled) {
        this.amqpEnabled = amqpEnabled;
    }

    public boolean isMqttEnabled() {
        return this.mqttEnabled;
    }

    public void setMqttEnabled(boolean mqttEnabled) {
        this.mqttEnabled = mqttEnabled;
    }

    public boolean isHttpEnabled() {
        return this.httpEnabled;
    }

    public void setHttpEnabled(boolean httpEnabled) {
        this.httpEnabled = httpEnabled;
    }

    public String getDefaultVirtualHost() {
        return this.defaultVirtualHost;
    }

    public void setDefaultVirtualHost(String defaultVirtualHost) {
        this.defaultVirtualHost = defaultVirtualHost;
    }

    public void setHttpGateway(FabricHTTPGateway httpGateway) {
        this.httpGateway = httpGateway;
        LOG.info("HTTP Gateway address is: " + httpGateway.getLocalAddress());
        if (this.detectingGateway != null) {
            this.detectingGateway.setHttpGateway(httpGateway.getLocalAddress());
        }
    }

    public void unsetHttpGateway(FabricHTTPGateway httpGateway) {
        this.httpGateway = null;
        if (this.detectingGateway != null) {
            this.detectingGateway.setHttpGateway(null);
        }
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public void setSslAlgorithm(String sslAlgorithm) {
        this.sslAlgorithm = sslAlgorithm;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setKeyStoreURL(URL keyStoreURL) {
        this.keyStoreURL = keyStoreURL;
    }

    public void setSslProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
    }

    public void setSslStoreType(String sslStoreType) {
        this.sslStoreType = sslStoreType;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public void setTrustStoreURL(URL trustStoreURL) {
        this.trustStoreURL = trustStoreURL;
    }

    public String getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String getDisabledCypherSuites() {
        return this.disabledCypherSuites;
    }

    public void setDisabledCypherSuites(String disabledCypherSuites) {
        this.disabledCypherSuites = disabledCypherSuites;
    }

    void bindMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    void unbindMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = null;
    }

    @Override
    public DetectingGateway getDetectingGateway() {
        return this.detectingGateway;
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }
}

