/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.AbstractElement;
import org.apache.qpid.proton.codec.impl.DescribedTypeImpl;
import org.apache.qpid.proton.codec.impl.Element;

class DescribedTypeElement
extends AbstractElement<DescribedType> {
    private Element _first;

    DescribedTypeElement(Element parent, Element prev) {
        super(parent, prev);
    }

    @Override
    public int size() {
        int count = 0;
        int size = 0;
        for (Element elt = this._first; elt != null; elt = elt.next()) {
            ++count;
            size += elt.size();
        }
        if (this.isElementOfArray()) {
            throw new IllegalArgumentException("Cannot add described type members to an array");
        }
        if (count > 2) {
            throw new IllegalArgumentException("Too many elements in described type");
        }
        size = count == 0 ? 3 : (count == 1 ? (size += 2) : ++size);
        return size;
    }

    @Override
    public DescribedType getValue() {
        Object descriptor = this._first == null ? null : this._first.getValue();
        Element second = this._first == null ? null : this._first.next();
        Object described = second == null ? null : second.getValue();
        return new DescribedTypeImpl(descriptor, described);
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.DESCRIBED;
    }

    @Override
    public int encode(ByteBuffer b) {
        int encodedSize = this.size();
        if (encodedSize > b.remaining()) {
            return 0;
        }
        b.put((byte)0);
        if (this._first == null) {
            b.put((byte)64);
            b.put((byte)64);
        } else {
            this._first.encode(b);
            if (this._first.next() == null) {
                b.put((byte)64);
            } else {
                this._first.next().encode(b);
            }
        }
        return encodedSize;
    }

    @Override
    public boolean canEnter() {
        return true;
    }

    @Override
    public Element child() {
        return this._first;
    }

    @Override
    public Element checkChild(Element element) {
        if (element.prev() != this._first) {
            throw new IllegalArgumentException("Described Type may only have two elements");
        }
        return element;
    }

    @Override
    public Element addChild(Element element) {
        this._first = element;
        return element;
    }
}

