/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.model;

import io.fabric8.gateway.loadbalancer.ClientRequestFacade;
import io.fabric8.gateway.model.UriTemplateDefinition;
import io.fabric8.gateway.model.loadbalancer.LoadBalancerDefinition;
import io.fabric8.gateway.model.loadbalancer.RoundRobinLoadBalanceDefinition;
import io.fabric8.gateway.support.MappingResult;
import io.fabric8.gateway.support.UriTemplate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyRule {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpProxyRule.class);
    private UriTemplateDefinition uriTemplate;
    private boolean reverseHeaders = true;
    private LoadBalancerDefinition loadBalancer = new RoundRobinLoadBalanceDefinition();
    private Set<UriTemplateDefinition> destinationUriTemplates = new HashSet<UriTemplateDefinition>();

    public HttpProxyRule() {
    }

    public HttpProxyRule(String uriTemplate) {
        this.uriTemplate = new UriTemplateDefinition(uriTemplate);
    }

    public MappingResult matches(String[] paths) {
        UriTemplate template = this.getUriTemplateObject();
        if (template == null) {
            LOG.warn("getUriTemplateObject() returned null!");
            return null;
        }
        return template.matches(paths, this);
    }

    public UriTemplateDefinition chooseBackEndService(ClientRequestFacade requestFacade) {
        UriTemplateDefinition loadBalancer = this.getLoadBalancer().getLoadBalancer();
        ArrayList<UriTemplateDefinition> uriDefList = new ArrayList<UriTemplateDefinition>(this.destinationUriTemplates);
        return loadBalancer.choose(uriDefList, requestFacade);
    }

    public void to(String destinationUriTemplate) {
        this.to(new UriTemplateDefinition(destinationUriTemplate));
    }

    public void to(UriTemplateDefinition templateDefinition) {
        this.destinationUriTemplates.add(templateDefinition);
    }

    public UriTemplate getUriTemplateObject() {
        return this.getUriTemplate().getUriTemplateObject();
    }

    public UriTemplateDefinition getUriTemplate() {
        return this.uriTemplate;
    }

    public void setUriTemplate(UriTemplateDefinition uriTemplate) {
        this.uriTemplate = uriTemplate;
    }

    public Set<UriTemplateDefinition> getDestinationUriTemplates() {
        return this.destinationUriTemplates;
    }

    public void setDestinationUriTemplates(Set<UriTemplateDefinition> destinationUriTemplates) {
        this.destinationUriTemplates = destinationUriTemplates;
    }

    public boolean isReverseHeaders() {
        return this.reverseHeaders;
    }

    public void setReverseHeaders(boolean reverseHeaders) {
        this.reverseHeaders = reverseHeaders;
    }

    public LoadBalancerDefinition getLoadBalancer() {
        return this.loadBalancer;
    }

    public void setLoadBalancer(LoadBalancerDefinition loadBalancer) {
        this.loadBalancer = loadBalancer;
    }
}

