/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol.openwire.command;

import io.fabric8.gateway.handlers.detecting.protocol.openwire.codec.OpenWireFormat;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.command.ActiveMQMessage;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.command.Message;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.support.OpenwireException;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.support.Settings;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.ByteArrayInputStream;
import org.fusesource.hawtbuf.ByteArrayOutputStream;

public class ActiveMQObjectMessage
extends ActiveMQMessage {
    public static final byte DATA_STRUCTURE_TYPE = 26;
    static final ClassLoader ACTIVEMQ_CLASSLOADER = ActiveMQObjectMessage.class.getClassLoader();
    protected transient Serializable object;

    @Override
    public Message copy() {
        ActiveMQObjectMessage copy = new ActiveMQObjectMessage();
        this.copy(copy);
        return copy;
    }

    private void copy(ActiveMQObjectMessage copy) {
        this.storeContent();
        super.copy(copy);
        copy.object = null;
    }

    @Override
    public void beforeMarshall(OpenWireFormat wireFormat) throws IOException {
        super.beforeMarshall(wireFormat);
        this.storeContent();
    }

    public void storeContent() {
        Buffer bodyAsBytes = this.getContent();
        if (bodyAsBytes == null && this.object != null) {
            try {
                ByteArrayOutputStream bytesOut;
                OutputStream os = bytesOut = new ByteArrayOutputStream();
                if (Settings.enable_compression()) {
                    this.compressed = true;
                    os = new DeflaterOutputStream(os);
                }
                DataOutputStream dataOut = new DataOutputStream(os);
                ObjectOutputStream objOut = new ObjectOutputStream(dataOut);
                objOut.writeObject(this.object);
                objOut.flush();
                objOut.reset();
                objOut.close();
                this.setContent(bytesOut.toBuffer());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.getMessage(), ioe);
            }
        }
    }

    @Override
    public byte getDataStructureType() {
        return 26;
    }

    public String getJMSXMimeType() {
        return "jms/object-message";
    }

    @Override
    public void clearBody() throws OpenwireException {
        super.clearBody();
        this.object = null;
    }

    public void setObject(Serializable newObject) throws OpenwireException {
        this.checkReadOnlyBody();
        this.object = newObject;
        this.setContent(null);
        this.storeContent();
    }

    public Serializable getObject() throws OpenwireException {
        if (this.object == null && this.getContent() != null) {
            Buffer content = this.getContent();
            InputStream is = new ByteArrayInputStream(content);
            if (this.isCompressed()) {
                is = new InflaterInputStream(is);
            }
            DataInputStream dataIn = new DataInputStream(is);
            throw new UnsupportedOperationException();
        }
        return this.object;
    }

    @Override
    public void clearMarshalledState() {
        super.clearMarshalledState();
        this.object = null;
    }

    @Override
    public void onMessageRolledBack() {
        super.onMessageRolledBack();
        this.object = null;
    }

    @Override
    public String toString() {
        try {
            this.getObject();
        }
        catch (OpenwireException openwireException) {
            // empty catch block
        }
        return super.toString();
    }
}

