/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol.openwire.codec.v1;

import io.fabric8.gateway.handlers.detecting.protocol.openwire.codec.BaseDataStreamMarshaller;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.codec.BooleanStream;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.codec.OpenWireFormat;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.command.BrokerId;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.command.DataStructure;
import io.fabric8.gateway.handlers.detecting.protocol.openwire.command.NetworkBridgeFilter;
import java.io.IOException;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;

public class NetworkBridgeFilterMarshaller
extends BaseDataStreamMarshaller {
    @Override
    public byte getDataStructureType() {
        return 91;
    }

    @Override
    public DataStructure createObject() {
        return new NetworkBridgeFilter();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataByteArrayInputStream dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        NetworkBridgeFilter info = (NetworkBridgeFilter)o;
        info.setNetworkTTL(dataIn.readInt());
        info.setNetworkBrokerId((BrokerId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        NetworkBridgeFilter info = (NetworkBridgeFilter)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        return (rc += this.tightMarshalCachedObject1(wireFormat, info.getNetworkBrokerId(), bs)) + 4;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataByteArrayOutputStream dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        NetworkBridgeFilter info = (NetworkBridgeFilter)o;
        dataOut.writeInt(info.getNetworkTTL());
        this.tightMarshalCachedObject2(wireFormat, info.getNetworkBrokerId(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataByteArrayInputStream dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        NetworkBridgeFilter info = (NetworkBridgeFilter)o;
        info.setNetworkTTL(dataIn.readInt());
        info.setNetworkBrokerId((BrokerId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataByteArrayOutputStream dataOut) throws IOException {
        NetworkBridgeFilter info = (NetworkBridgeFilter)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeInt(info.getNetworkTTL());
        this.looseMarshalCachedObject(wireFormat, info.getNetworkBrokerId(), dataOut);
    }
}

