/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway;

import io.fabric8.gateway.ServiceDetails;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceMap {
    private ConcurrentHashMap<String, Map<String, ServiceDetails>> map = new ConcurrentHashMap();

    public List<ServiceDetails> getServices(String path) {
        Map<String, ServiceDetails> pathMap = this.getPathMap(path);
        return new ArrayList<ServiceDetails>(pathMap.values());
    }

    public List<String> getPaths() {
        return new ArrayList<String>(this.map.keySet());
    }

    public void serviceUpdated(String path, ServiceDetails service) {
        if (!service.getServices().isEmpty()) {
            this.getPathMap(path).put(service.getId(), service);
        }
    }

    public void serviceRemoved(String path, ServiceDetails service) {
        this.getPathMap(path).remove(service.getId());
    }

    protected Map<String, ServiceDetails> getPathMap(String path) {
        ConcurrentHashMap<String, ServiceDetails> initial = new ConcurrentHashMap<String, ServiceDetails>();
        ConcurrentHashMap<String, ServiceDetails> answer = this.map.putIfAbsent(path, initial);
        if (answer == null) {
            answer = initial;
        }
        return answer;
    }
}

