/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.ProtonJSession;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.impl.ConnectionImpl;
import org.apache.qpid.proton.engine.impl.EndpointImpl;
import org.apache.qpid.proton.engine.impl.EndpointImplQuery;
import org.apache.qpid.proton.engine.impl.LinkNode;
import org.apache.qpid.proton.engine.impl.ReceiverImpl;
import org.apache.qpid.proton.engine.impl.SenderImpl;
import org.apache.qpid.proton.engine.impl.TransportSession;

public class SessionImpl
extends EndpointImpl
implements ProtonJSession {
    private final ConnectionImpl _connection;
    private Map<String, SenderImpl> _senders = new LinkedHashMap<String, SenderImpl>();
    private Map<String, ReceiverImpl> _receivers = new LinkedHashMap<String, ReceiverImpl>();
    private TransportSession _transportSession;
    private int _incomingCapacity = 0x100000;
    private int _incomingBytes = 0;
    private int _outgoingBytes = 0;
    private int _incomingDeliveries = 0;
    private int _outgoingDeliveries = 0;
    private LinkNode<SessionImpl> _node;

    SessionImpl(ConnectionImpl connection) {
        this._connection = connection;
        this._node = this._connection.addSessionEndpoint(this);
    }

    @Override
    public void open() {
        super.open();
        this.modified();
    }

    @Override
    public void close() {
        super.close();
        this.modified();
    }

    @Override
    public SenderImpl sender(String name) {
        SenderImpl sender = this._senders.get(name);
        if (sender == null) {
            sender = new SenderImpl(this, name);
            this._senders.put(name, sender);
        }
        return sender;
    }

    public ReceiverImpl receiver(String name) {
        ReceiverImpl receiver = this._receivers.get(name);
        if (receiver == null) {
            receiver = new ReceiverImpl(this, name);
            this._receivers.put(name, receiver);
        }
        return receiver;
    }

    public Session next(EnumSet<EndpointState> local, EnumSet<EndpointState> remote) {
        EndpointImplQuery query = new EndpointImplQuery(local, remote);
        LinkNode<SessionImpl> sessionNode = this._node.next(query);
        return sessionNode == null ? null : sessionNode.getValue();
    }

    @Override
    protected ConnectionImpl getConnectionImpl() {
        return this._connection;
    }

    public ConnectionImpl getConnection() {
        return this.getConnectionImpl();
    }

    @Override
    public void free() {
        super.free();
        this._connection.removeSessionEndpoint(this._node);
        this._node = null;
        for (SenderImpl sender : this._senders.values()) {
            sender.free();
        }
        this._senders.clear();
        for (ReceiverImpl receiver : this._receivers.values()) {
            receiver.free();
        }
        this._receivers.clear();
    }

    TransportSession getTransportSession() {
        return this._transportSession;
    }

    void setTransportSession(TransportSession transportSession) {
        this._transportSession = transportSession;
    }

    void setNode(LinkNode<SessionImpl> node) {
        this._node = node;
    }

    void freeSender(SenderImpl sender) {
        this._senders.remove(sender.getName());
    }

    void freeReceiver(ReceiverImpl receiver) {
        this._receivers.remove(receiver.getName());
    }

    public int getIncomingCapacity() {
        return this._incomingCapacity;
    }

    public void setIncomingCapacity(int capacity) {
        this._incomingCapacity = capacity;
    }

    public int getIncomingBytes() {
        return this._incomingBytes;
    }

    void incrementIncomingBytes(int delta) {
        this._incomingBytes += delta;
    }

    public int getOutgoingBytes() {
        return this._outgoingBytes;
    }

    void incrementOutgoingBytes(int delta) {
        this._outgoingBytes += delta;
    }

    void incrementIncomingDeliveries(int delta) {
        this._incomingDeliveries += delta;
    }

    int getOutgoingDeliveries() {
        return this._outgoingDeliveries;
    }

    void incrementOutgoingDeliveries(int delta) {
        this._outgoingDeliveries += delta;
    }
}

