/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting.protocol.ssl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;

public class SslConfig {
    private URL keyStoreURL;
    private String keyStorePassword;
    private KeyStore keyStore;
    private URL trustStoreURL;
    private String trustStorePassword;
    private KeyStore trustStore;
    private String keyAlias;
    private String keyPassword;
    String storeType;
    String algorithm;
    TrustManager[] trustManagers;
    KeyManager[] keyManagers;
    private String protocol = "TLS";
    String disabledCypherSuites;
    String enabledCipherSuites;

    public SslConfig() {
    }

    public SslConfig(File keyStoreFile, String keyStorePassword) {
        this(SslConfig.url(keyStoreFile), keyStorePassword);
    }

    public SslConfig(File keyStoreFile, String keyStorePassword, File trustStoreFile, String trustStorePassword) {
        this(SslConfig.url(keyStoreFile), keyStorePassword, SslConfig.url(trustStoreFile), trustStorePassword);
    }

    private static URL url(File fil) {
        if (fil == null) {
            return null;
        }
        try {
            return fil.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public SslConfig(URL keyStoreURL, String keyStorePassword) {
        this(keyStoreURL, keyStorePassword, null, null);
    }

    public SslConfig(URL keyStoreURL, String keyStorePassword, URL trustStoreURL, String trustStorePassword) {
        this.keyStoreURL = keyStoreURL;
        this.keyStorePassword = keyStorePassword;
        this.trustStoreURL = trustStoreURL;
        this.trustStorePassword = trustStorePassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getKeyStore() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        if (this.keyStore == null) {
            if (this.storeType == null) {
                this.storeType = "JKS";
            }
            if (this.keyStorePassword == null) {
                this.keyStorePassword = "";
            }
            KeyStore store = KeyStore.getInstance(this.storeType);
            InputStream stream = this.keyStoreURL.openStream();
            try {
                store.load(stream, this.keyStorePassword.toCharArray());
            }
            finally {
                stream.close();
            }
            this.keyStore = store;
        }
        return this.keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getTrustStore() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        if (this.trustStoreURL == null) {
            return this.getKeyStore();
        }
        if (this.trustStore == null) {
            if (this.storeType == null) {
                this.storeType = "JKS";
            }
            if (this.trustStorePassword == null) {
                this.trustStorePassword = "";
            }
            KeyStore store = KeyStore.getInstance(this.storeType);
            InputStream stream = this.trustStoreURL.openStream();
            try {
                store.load(stream, this.trustStorePassword.toCharArray());
            }
            finally {
                stream.close();
            }
            this.trustStore = store;
        }
        return this.trustStore;
    }

    public TrustManager[] getTrustManagers() throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        if (this.trustManagers == null) {
            if (this.algorithm == null) {
                this.algorithm = "SunX509";
            }
            TrustManagerFactory factory = TrustManagerFactory.getInstance(this.algorithm);
            factory.init(this.getTrustStore());
            this.trustManagers = factory.getTrustManagers();
        }
        return this.trustManagers;
    }

    public KeyManager[] getKeyManagers() throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException, UnrecoverableKeyException {
        if (this.keyManagers == null) {
            if (this.algorithm == null) {
                this.algorithm = "SunX509";
            }
            if (this.keyPassword == null) {
                this.keyPassword = "";
            }
            KeyManagerFactory factory = KeyManagerFactory.getInstance(this.algorithm);
            factory.init(this.getKeyStore(), this.keyPassword.toCharArray());
            this.keyManagers = factory.getKeyManagers();
            if (this.keyAlias != null) {
                for (int i = 0; i < this.keyManagers.length; ++i) {
                    KeyManager keyManager = this.keyManagers[i];
                    if (!(keyManager instanceof X509ExtendedKeyManager)) continue;
                    this.keyManagers[i] = new AliasFilteringKeyManager(this.keyAlias, (X509ExtendedKeyManager)keyManager);
                }
            }
        }
        return this.keyManagers;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getStoreType() {
        return this.storeType;
    }

    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public URL getKeyStoreURL() {
        return this.keyStoreURL;
    }

    public void setKeyStoreURL(URL keyStoreURL) {
        this.keyStoreURL = keyStoreURL;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public URL getTrustStoreURL() {
        return this.trustStoreURL;
    }

    public void setTrustStoreURL(URL trustStoreURL) {
        this.trustStoreURL = trustStoreURL;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getDisabledCypherSuites() {
        return this.disabledCypherSuites;
    }

    public void setDisabledCypherSuites(String disabledCypherSuites) {
        this.disabledCypherSuites = disabledCypherSuites;
    }

    public String getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public void setEnabledCipherSuites(String enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
    }

    static class AliasFilteringKeyManager
    extends X509ExtendedKeyManager {
        private final String alias;
        private final X509ExtendedKeyManager next;

        AliasFilteringKeyManager(String alias, X509ExtendedKeyManager next) {
            this.alias = alias;
            this.next = next;
        }

        @Override
        public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
            return this.alias;
        }

        @Override
        public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
            return this.alias;
        }

        @Override
        public String chooseEngineClientAlias(String[] strings, Principal[] principals, SSLEngine sslEngine) {
            return this.alias;
        }

        @Override
        public String chooseEngineServerAlias(String s, Principal[] principals, SSLEngine sslEngine) {
            return this.alias;
        }

        @Override
        public X509Certificate[] getCertificateChain(String s) {
            return this.next.getCertificateChain(s);
        }

        @Override
        public String[] getClientAliases(String s, Principal[] principals) {
            return this.next.getClientAliases(s, principals);
        }

        @Override
        public PrivateKey getPrivateKey(String s) {
            return this.next.getPrivateKey(s);
        }

        @Override
        public String[] getServerAliases(String s, Principal[] principals) {
            return this.next.getServerAliases(s, principals);
        }
    }
}

