/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.handlers.detecting;

import io.fabric8.gateway.handlers.detecting.DetectingGatewayNetSocketHandler;
import io.fabric8.gateway.handlers.detecting.DetectingGatewayProtocolHandler;
import io.fabric8.gateway.handlers.detecting.FutureHandler;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.net.NetServer;

public class DetectingGateway {
    private static final transient Logger LOG = LoggerFactory.getLogger(DetectingGateway.class);
    private final Vertx vertx;
    private final int port;
    private final DetectingGatewayProtocolHandler handler;
    private String host;
    private NetServer server;
    private FutureHandler<AsyncResult<NetServer>> listenFuture = new FutureHandler<AsyncResult<NetServer>>(){

        @Override
        public void handle(AsyncResult<NetServer> event) {
            if (event.succeeded()) {
                LOG.info(String.format("Gateway listening on %s:%d for protocols: %s", DetectingGateway.this.server.host(), DetectingGateway.this.server.port(), DetectingGateway.this.handler.getProtocolNames()));
            }
            super.handle(event);
        }
    };

    public DetectingGateway(Vertx vertx, int port, DetectingGatewayProtocolHandler handler) {
        this.vertx = vertx;
        this.port = port;
        this.handler = handler;
    }

    public String toString() {
        return "DetectingGateway{, port=" + this.port + ", host='" + this.host + '\'' + ", protocols='" + this.handler.getProtocolNames() + '\'' + '}';
    }

    public void init() {
        this.server = this.vertx.createNetServer().connectHandler(new DetectingGatewayNetSocketHandler(this.handler));
        this.server = this.host != null ? this.server.listen(this.port, this.host, this.listenFuture) : this.server.listen(this.port, this.listenFuture);
    }

    public void destroy() {
        this.server.close();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getBoundPort() throws Exception {
        return ((NetServer)FutureHandler.result(this.listenFuture)).port();
    }

    public DetectingGatewayProtocolHandler getHandler() {
        return this.handler;
    }

    public void setHttpGateway(InetSocketAddress value) {
        this.handler.setHttpGateway(value);
    }

    public InetSocketAddress getHttpGateway() {
        return this.handler.getHttpGateway();
    }
}

