/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.dns.impl.netty;

import org.vertx.java.core.dns.impl.netty.DnsHeader;
import org.vertx.java.core.dns.impl.netty.DnsMessage;

public class DnsResponseHeader
extends DnsHeader {
    private int readQuestions;
    private int readAnswers;
    private int readAuthorityResources;
    private int readAdditionalResources;
    private boolean authoritativeAnswer;
    private boolean truncated;
    private boolean recursionAvailable;
    private int z;
    private int responseCode;

    public DnsResponseHeader(DnsMessage<? extends DnsResponseHeader> parent, int id) {
        super(parent);
        this.setId(id);
        this.setType(1);
    }

    public boolean isAuthoritativeAnswer() {
        return this.authoritativeAnswer;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public boolean isRecursionAvailable() {
        return this.recursionAvailable;
    }

    public int getZ() {
        return this.z;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public int getReadQuestions() {
        return this.readQuestions;
    }

    public int getReadAnswers() {
        return this.readAnswers;
    }

    public int getReadAuthorityResources() {
        return this.readAuthorityResources;
    }

    public int getReadAdditionalResources() {
        return this.readAdditionalResources;
    }

    @Override
    public final int getType() {
        return 1;
    }

    public void setAuthoritativeAnswer(boolean authoritativeAnswer) {
        this.authoritativeAnswer = authoritativeAnswer;
    }

    public void setTruncated(boolean truncated) {
        this.truncated = truncated;
    }

    public void setRecursionAvailable(boolean recursionAvailable) {
        this.recursionAvailable = recursionAvailable;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public void setReadQuestions(int readQuestions) {
        this.readQuestions = readQuestions;
    }

    public void setReadAnswers(int readAnswers) {
        this.readAnswers = readAnswers;
    }

    public void setReadAuthorityResources(int readAuthorityResources) {
        this.readAuthorityResources = readAuthorityResources;
    }

    public void setReadAdditionalResources(int readAdditionalResources) {
        this.readAdditionalResources = readAdditionalResources;
    }

    @Override
    public final DnsResponseHeader setType(int type) {
        if (type != 1) {
            throw new IllegalArgumentException("type cannot be anything but TYPE_RESPONSE (1) for a response header.");
        }
        super.setType(type);
        return this;
    }
}

