/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.net.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import org.vertx.java.core.AsyncResult;
import org.vertx.java.core.Handler;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.impl.DefaultFutureResult;
import org.vertx.java.core.impl.VertxInternal;

public abstract class ConnectionBase {
    protected final VertxInternal vertx;
    protected final Channel channel;
    protected final DefaultContext context;
    protected Handler<Throwable> exceptionHandler;
    protected Handler<Void> closeHandler;
    private volatile boolean writable = true;
    private boolean read;
    private boolean needsFlush;

    protected ConnectionBase(VertxInternal vertx, Channel channel, DefaultContext context) {
        this.vertx = vertx;
        this.channel = channel;
        this.context = context;
    }

    public final void startRead() {
        this.read = true;
    }

    public final void endReadAndFlush() {
        this.read = false;
        if (this.needsFlush) {
            this.needsFlush = false;
            this.channel.flush();
        }
    }

    public ChannelFuture queueForWrite(Object obj) {
        this.needsFlush = true;
        return this.channel.write(obj);
    }

    public ChannelFuture write(Object obj) {
        if (this.read) {
            return this.queueForWrite(obj);
        }
        if (this.channel.isOpen()) {
            return this.channel.writeAndFlush(obj);
        }
        return null;
    }

    public void close() {
        this.endReadAndFlush();
        this.channel.close();
    }

    public void doPause() {
        this.channel.config().setAutoRead(false);
    }

    public void doResume() {
        this.channel.config().setAutoRead(true);
    }

    public void doSetWriteQueueMaxSize(int size) {
        this.channel.config().setWriteBufferLowWaterMark(size / 2);
        this.channel.config().setWriteBufferHighWaterMark(size);
    }

    public boolean doWriteQueueFull() {
        return !this.writable;
    }

    protected void setWritable(boolean writable) {
        this.writable = writable;
    }

    protected DefaultContext getContext() {
        return this.context;
    }

    protected void handleException(Throwable t) {
        if (this.exceptionHandler != null) {
            this.setContext();
            try {
                this.exceptionHandler.handle(t);
            }
            catch (Throwable t2) {
                this.handleHandlerException(t2);
            }
        }
    }

    protected void handleClosed() {
        if (this.closeHandler != null) {
            this.setContext();
            try {
                this.closeHandler.handle(null);
            }
            catch (Throwable t) {
                this.handleHandlerException(t);
            }
        }
    }

    protected void addFuture(final Handler<AsyncResult<Void>> doneHandler, ChannelFuture future) {
        if (future != null) {
            future.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(final ChannelFuture channelFuture) throws Exception {
                    if (doneHandler != null) {
                        ConnectionBase.this.context.execute(new Runnable(){

                            @Override
                            public void run() {
                                if (channelFuture.isSuccess()) {
                                    doneHandler.handle(new DefaultFutureResult<Void>((Void)null));
                                } else {
                                    doneHandler.handle(new DefaultFutureResult<Throwable>(channelFuture.cause()));
                                }
                            }
                        });
                    } else if (!channelFuture.isSuccess()) {
                        ConnectionBase.this.vertx.reportException(channelFuture.cause());
                    }
                }
            });
        }
    }

    protected void setContext() {
        this.vertx.setContext(this.context);
    }

    protected void handleHandlerException(Throwable t) {
        this.vertx.reportException(t);
    }

    protected boolean isSSL() {
        return this.channel.pipeline().get(SslHandler.class) != null;
    }

    protected ChannelFuture sendFile(File file) {
        try {
            ChannelFuture writeFuture;
            final RandomAccessFile raf = new RandomAccessFile(file, "r");
            long fileLength = file.length();
            if (this.isSSL()) {
                writeFuture = this.write(new ChunkedFile(raf, 0L, fileLength, 8192));
            } else {
                DefaultFileRegion region = new DefaultFileRegion(raf.getChannel(), 0L, fileLength);
                writeFuture = this.write(region);
            }
            writeFuture.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    raf.close();
                }
            });
            return writeFuture;
        }
        catch (IOException e) {
            this.handleException(e);
            return null;
        }
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.isSSL()) {
            ChannelHandlerContext sslHandlerContext = this.channel.pipeline().context("ssl");
            assert (sslHandlerContext != null);
            SslHandler sslHandler = (SslHandler)sslHandlerContext.handler();
            return sslHandler.engine().getSession().getPeerCertificateChain();
        }
        return null;
    }

    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    protected abstract void handleInterestedOpsChanged();
}

