/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.kubernetes;

import io.fabric8.forge.kubernetes.AbstractKubernetesCommand;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class ServiceDelete
extends AbstractKubernetesCommand {
    @Inject
    @WithAttributes(label="Service ID", description="The ID of the service to delete.", required=true)
    UIInput<String> serviceId;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).category(Categories.create((String[])new String[]{CATEGORY})).name(CATEGORY + ": Service Delete").description("Deletes the given service from the kubernetes cloud");
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        this.serviceId.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                List items;
                ArrayList<String> list = new ArrayList<String>();
                ServiceList services = ServiceDelete.this.getKubernetes().getServices();
                if (services != null && (items = services.getItems()) != null) {
                    for (Service item : items) {
                        String id = KubernetesHelper.getName((Service)item);
                        list.add(id);
                    }
                }
                Collections.sort(list);
                return list;
            }
        });
        builder.add(this.serviceId);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        String idText = (String)this.serviceId.getValue();
        Service service = this.getKubernetes().getService(idText);
        if (service == null) {
            System.out.println("No service for id: " + idText);
        } else {
            this.executeService(service);
        }
        return null;
    }

    protected void executeService(Service service) throws Exception {
        this.getKubernetes().deleteService(KubernetesHelper.getName((Service)service));
    }
}

