/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import io.fabric8.forge.camel.commands.project.completer.SpringBootConfigurationResourcesFilesVisitor;
import io.fabric8.forge.camel.commands.project.helper.CamelXmlHelper;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.resource.visit.ResourceVisitor;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;

public class SpringBootConfigurationFileCompleter
implements UICompleter<String> {
    private final Set<String> files = new TreeSet<String>();
    private final Set<String> directories = new TreeSet<String>();

    public SpringBootConfigurationFileCompleter(ResourcesFacet facet, Function<String, Boolean> filter) {
        if (facet != null) {
            SpringBootConfigurationResourcesFilesVisitor visitor = new SpringBootConfigurationResourcesFilesVisitor(facet, this.files, this.directories, filter);
            facet.visitResources((ResourceVisitor)visitor);
        }
    }

    public Set<String> getDirectories() {
        return this.directories;
    }

    public Set<String> getFiles() {
        return this.files;
    }

    public Iterable<String> getCompletionProposals(UIContext context, InputComponent input, String value) {
        ArrayList<String> answer = new ArrayList<String>();
        for (String name : this.files) {
            if (value != null && !name.startsWith(value)) continue;
            answer.add(name);
        }
        return answer;
    }

    public void validateFileDoesNotExist(UIInput<String> directory, UIInput<String> fileName, UIValidationContext validator) {
        String resourcePath = CamelXmlHelper.createFileName(directory, fileName);
        if (this.files.contains(resourcePath)) {
            validator.addValidationError(fileName, "A file with that name already exists!");
        }
    }
}

