/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.dto;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.camel.tooling.util.Strings2;
import io.fabric8.forge.addon.utils.Indenter;
import io.fabric8.forge.camel.commands.project.dto.ContextDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDtoSupport;
import io.fabric8.utils.Block;
import io.fabric8.utils.Objects;
import io.fabric8.utils.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NodeDtos {
    private static final Set<String> patternsToPrefix = new HashSet<String>(Arrays.asList("camelContext", "routes", "route", "from", "to"));

    public static List<NodeDto> toNodeList(Iterable<? extends NodeDto> nodes) {
        return NodeDtos.toNodeList(nodes, "  ");
    }

    public static List<NodeDto> toNodeList(Iterable<? extends NodeDto> nodes, String indentation) {
        ArrayList<NodeDto> answer = new ArrayList<NodeDto>();
        if (nodes != null) {
            for (NodeDto nodeDto : nodes) {
                List<NodeDto> list = nodeDto.toNodeList(indentation);
                answer.addAll(list);
            }
        }
        return answer;
    }

    public static List<ContextDto> parseContexts(File file) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        MappingIterator iter = mapper.readerFor(ContextDto.class).readValues(file);
        return NodeDtos.toList(iter);
    }

    public static List<ContextDto> parseContexts(String message) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        MappingIterator iter = mapper.readerFor(ContextDto.class).readValues(message);
        return NodeDtos.toList(iter);
    }

    protected static <T> List<T> toList(MappingIterator<T> iter) throws IOException {
        ArrayList<Object> answer = new ArrayList<Object>();
        while (iter != null && iter.hasNextValue()) {
            Object value = iter.nextValue();
            answer.add(value);
        }
        return answer;
    }

    public static void printNode(final Indenter out, final NodeDtoSupport node) throws Exception {
        if (node != null) {
            out.println(NodeDtos.getNodeText(node));
            out.withIndent(new Block(){

                public void invoke() throws Exception {
                    for (NodeDto child : node.getChildren()) {
                        NodeDtos.printNode(out, child);
                    }
                }
            });
        }
    }

    public static String getNodeText(NodeDtoSupport node) {
        String pattern = Strings2.getOrElse((Object)node.getPattern());
        String label = Strings2.getOrElse((Object)node.getLabel());
        if (patternsToPrefix.contains(pattern)) {
            return Strings.join((String)" ", (Object[])new Object[]{pattern, label});
        }
        return label;
    }

    public static NodeDto findNodeByKey(Iterable<? extends NodeDto> nodes, String key) {
        if (nodes != null) {
            for (NodeDto nodeDto : nodes) {
                if (Objects.equal((Object)nodeDto.getKey(), (Object)key)) {
                    return nodeDto;
                }
                NodeDto answer = NodeDtos.findNodeByKey(nodeDto.getChildren(), key);
                if (answer == null) continue;
                return answer;
            }
        }
        return null;
    }
}

