/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import io.fabric8.forge.camel.commands.project.completer.XmlResourcesCamelEndpointsVisitor;
import io.fabric8.forge.camel.commands.project.completer.XmlWebResourcesCamelEndpointsVisitor;
import io.fabric8.forge.camel.commands.project.model.CamelEndpointDetails;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.resource.visit.ResourceVisitor;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;

public class XmlEndpointsCompleter
implements UICompleter<String> {
    private final List<CamelEndpointDetails> endpoints = new ArrayList<CamelEndpointDetails>();

    public XmlEndpointsCompleter(ResourcesFacet facet, WebResourcesFacet webFacet, Function<String, Boolean> filter) {
        Object visitor;
        if (facet != null) {
            visitor = new XmlResourcesCamelEndpointsVisitor(facet, this.endpoints, filter);
            facet.visitResources((ResourceVisitor)visitor);
        }
        if (webFacet != null) {
            visitor = new XmlWebResourcesCamelEndpointsVisitor(webFacet, this.endpoints, filter);
            webFacet.visitWebResources((ResourceVisitor)visitor);
        }
    }

    public List<CamelEndpointDetails> getEndpoints() {
        return this.endpoints;
    }

    public List<String> getEndpointUris() {
        ArrayList<String> uris = new ArrayList<String>();
        for (CamelEndpointDetails detail : this.endpoints) {
            uris.add(detail.getEndpointUri());
        }
        return uris;
    }

    public CamelEndpointDetails getEndpointDetail(String uri) {
        for (CamelEndpointDetails detail : this.endpoints) {
            if (!detail.getEndpointUri().equals(uri)) continue;
            return detail;
        }
        return null;
    }

    public Iterable<String> getCompletionProposals(UIContext context, InputComponent input, String value) {
        ArrayList<String> answer = new ArrayList<String>();
        for (CamelEndpointDetails detail : this.endpoints) {
            if (value != null && !detail.getEndpointUri().startsWith(value)) continue;
            answer.add(detail.getEndpointUri());
        }
        return answer;
    }
}

