/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.ConfigureEndpointPropertiesStep;
import io.fabric8.forge.camel.commands.project.completer.XmlFileCompleter;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.model.EndpointOptionByGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.input.events.ValueChangeEvent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class CamelAddEndpointXmlCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    private static final int MAX_OPTIONS = 20;
    @Inject
    @WithAttributes(label="Filter", required=false, description="To filter components")
    private UISelectOne<String> componentNameFilter;
    @Inject
    @WithAttributes(label="Name", required=true, description="Name of component to use for the endpoint")
    private UISelectOne<String> componentName;
    @Inject
    @WithAttributes(label="Endpoint type", required=true, description="Type of endpoint")
    private UISelectOne<String> endpointType;
    @Inject
    @WithAttributes(label="Instance Name", required=true, description="Name of endpoint instance to add")
    private UIInput<String> instanceName;
    @Inject
    @WithAttributes(label="XML File", required=true, description="The XML file to use (either Spring or Blueprint)")
    private UISelectOne<String> xml;
    @Inject
    private InputComponentFactory componentFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelAddEndpointXmlCommand.class).name("Camel: Add Endpoint XML").category(Categories.create((String[])new String[]{CATEGORY})).description("Adds a Camel endpoint to an existing XML file");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        boolean enabled = super.isEnabled(context);
        if (enabled) {
            boolean spring = CamelCommandsHelper.isSpringProject(this.getSelectedProject(context));
            boolean blueprint = CamelCommandsHelper.isBlueprintProject(this.getSelectedProject(context));
            return spring || blueprint;
        }
        return false;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Map attributeMap = builder.getUIContext().getAttributeMap();
        attributeMap.remove("navigationResult");
        Project project = this.getSelectedProject(builder.getUIContext());
        ResourcesFacet resourcesFacet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        this.componentNameFilter.setValueChoices(CamelCommandsHelper.createComponentNameValues(project));
        this.componentNameFilter.setDefaultValue((Object)"<all>");
        this.componentName.setValueChoices(CamelCommandsHelper.createComponentNameValues(project, this.componentNameFilter, false));
        this.componentName.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged(ValueChangeEvent event) {
                String component;
                String string = component = event.getNewValue() != null ? event.getNewValue().toString() : null;
                if (component != null) {
                    String description = CamelCatalogHelper.getComponentDescription(component);
                    CamelAddEndpointXmlCommand.this.componentName.setNote(description != null ? description : "");
                } else {
                    CamelAddEndpointXmlCommand.this.componentName.setNote("");
                }
                if (component != null) {
                    boolean consumerOnly = CamelCatalogHelper.isComponentConsumerOnly(component);
                    boolean producerOnly = CamelCatalogHelper.isComponentConsumerOnly(component);
                    if (consumerOnly) {
                        String[] types = new String[]{"Consumer"};
                        CamelAddEndpointXmlCommand.this.endpointType.setValueChoices(Arrays.asList(types));
                        CamelAddEndpointXmlCommand.this.endpointType.setValue((Object)"Consumer");
                        CamelAddEndpointXmlCommand.this.endpointType.setDefaultValue((Object)"Consumer");
                    } else if (producerOnly) {
                        String[] types = new String[]{"Producer"};
                        CamelAddEndpointXmlCommand.this.endpointType.setValueChoices(Arrays.asList(types));
                        CamelAddEndpointXmlCommand.this.endpointType.setValue((Object)"Producer");
                        CamelAddEndpointXmlCommand.this.endpointType.setDefaultValue((Object)"Producer");
                    } else {
                        String[] types = new String[]{"<any>", "Consumer", "Producer"};
                        CamelAddEndpointXmlCommand.this.endpointType.setValueChoices(Arrays.asList(types));
                        CamelAddEndpointXmlCommand.this.endpointType.setValue((Object)"<any>");
                        CamelAddEndpointXmlCommand.this.endpointType.setDefaultValue((Object)"<any>");
                    }
                } else {
                    String[] types = new String[]{"<any>", "Consumer", "Producer"};
                    CamelAddEndpointXmlCommand.this.endpointType.setValueChoices(Arrays.asList(types));
                    CamelAddEndpointXmlCommand.this.endpointType.setValue((Object)"<any>");
                    CamelAddEndpointXmlCommand.this.endpointType.setDefaultValue((Object)"<any>");
                }
            }
        });
        String[] types = new String[]{"<any>", "Consumer", "Producer"};
        this.endpointType.setValueChoices(Arrays.asList(types));
        this.endpointType.setDefaultValue((Object)"<any>");
        this.xml.setValueChoices(new XmlFileCompleter(resourcesFacet, webResourcesFacet).getFiles());
        builder.add(this.componentNameFilter).add(this.componentName).add(this.endpointType).add(this.instanceName).add(this.xml);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        NavigationResult navigationResult;
        Map attributeMap = context.getUIContext().getAttributeMap();
        attributeMap.put("instanceName", this.instanceName.getValue());
        attributeMap.put("xml", this.xml.getValue());
        attributeMap.put("mode", "add");
        attributeMap.put("kind", "xml");
        String previous = (String)attributeMap.get("componentName");
        String previous2 = (String)attributeMap.get("endpointType");
        if (previous != null && previous.equals(this.componentName.getValue()) && previous2 != null && previous2.equals(this.endpointType.getValue()) && (navigationResult = (NavigationResult)attributeMap.get("navigationResult")) != null) {
            return navigationResult;
        }
        attributeMap.put("componentName", this.componentName.getValue());
        attributeMap.put("endpointType", this.endpointType.getValue());
        String camelComponentName = (String)this.componentName.getValue();
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        String json = catalog.componentJSonSchema(camelComponentName);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + camelComponentName);
        }
        boolean consumerOnly = false;
        boolean producerOnly = false;
        String type = (String)this.endpointType.getValue();
        if ("Consumer".equals(type)) {
            consumerOnly = true;
        } else if ("Producer".equals(type)) {
            producerOnly = true;
        }
        List<EndpointOptionByGroup> groups = CamelCommandsHelper.createUIInputsForCamelComponent(camelComponentName, null, 20, consumerOnly, producerOnly, this.componentFactory, this.converterFactory);
        ArrayList<InputComponent> allInputs = new ArrayList<InputComponent>();
        for (EndpointOptionByGroup group : groups) {
            allInputs.addAll(group.getInputs());
        }
        NavigationResultBuilder builder = Results.navigationBuilder();
        int pages = groups.size();
        for (int i = 0; i < pages; ++i) {
            boolean last = i == pages - 1;
            EndpointOptionByGroup current = groups.get(i);
            ConfigureEndpointPropertiesStep step = new ConfigureEndpointPropertiesStep(this.projectFactory, this.dependencyInstaller, camelComponentName, current.getGroup(), allInputs, current.getInputs(), last, i, pages);
            builder.add((UICommand)step);
        }
        NavigationResult navigationResult2 = builder.build();
        attributeMap.put("navigationResult", navigationResult2);
        return navigationResult2;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return Results.success();
    }
}

