/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.completer.PackageNameCompleter;
import io.fabric8.forge.addon.utils.validator.ClassNameValidator;
import io.fabric8.forge.addon.utils.validator.PackageNameValidator;
import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.ConfigureComponentPropertiesStep;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.ClassLoaderFacet;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.input.events.ValueChangeEvent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.validate.UIValidator;
import org.jboss.forge.addon.ui.wizard.UIWizard;
import org.jboss.forge.roaster.model.util.Strings;

@FacetConstraint(value={JavaSourceFacet.class, ResourcesFacet.class, ClassLoaderFacet.class})
public class CamelNewComponentInstanceCDICommand
extends AbstractCamelProjectCommand
implements UIWizard {
    @Inject
    @WithAttributes(label="Filter", required=false, description="To filter components")
    private UISelectOne<String> componentNameFilter;
    @Inject
    @WithAttributes(label="Component Name", required=true, description="Name of component type to add")
    private UISelectOne<String> componentName;
    @Inject
    @WithAttributes(label="Instance Name", required=true, description="Name of component instance to add")
    private UISelectOne<String> instanceName;
    @Inject
    @WithAttributes(label="Package Name", required=false, description="The package name where this type will be created")
    private UIInput<String> targetPackage;
    @Inject
    @WithAttributes(label="Class Name", required=true, description="Name of @Producer class")
    private UIInput<String> className;
    @Inject
    private DependencyInstaller dependencyInstaller;
    @Inject
    private DependencyResolver dependencyResolver;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelNewComponentInstanceCDICommand.class).name("Camel: New Component CDI").category(Categories.create((String[])new String[]{CATEGORY})).description("Creates a new Camel component instance configuration using CDI");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        boolean enabled = super.isEnabled(context);
        if (enabled) {
            return CamelCommandsHelper.isCdiProject(this.getSelectedProject(context));
        }
        return false;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject(builder.getUIContext());
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        this.componentNameFilter.setValueChoices(CamelCommandsHelper.createComponentNameValues(project));
        this.componentNameFilter.setDefaultValue((Object)"<all>");
        this.componentName.setValueChoices(CamelCommandsHelper.createComponentNameValues(project, this.componentNameFilter, false));
        this.componentName.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged(ValueChangeEvent event) {
                String component;
                String string = component = event.getNewValue() != null ? event.getNewValue().toString() : null;
                if (component != null) {
                    String description = CamelCatalogHelper.getComponentDescription(component);
                    CamelNewComponentInstanceCDICommand.this.componentName.setNote(description != null ? description : "");
                } else {
                    CamelNewComponentInstanceCDICommand.this.componentName.setNote("");
                }
            }
        });
        this.targetPackage.setCompleter((UICompleter)new PackageNameCompleter(facet));
        this.targetPackage.addValidator((UIValidator)new PackageNameValidator());
        this.targetPackage.setDefaultValue((Object)"org.apache.camel.cdi.producers");
        this.className.addValidator((UIValidator)new ClassNameValidator(false));
        this.className.setDefaultValue((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return CamelNewComponentInstanceCDICommand.this.getDefaultProducerClassName();
            }
        });
        builder.add(this.componentNameFilter).add(this.componentName).add(this.instanceName).add(this.targetPackage).add(this.className);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        Map attributeMap = context.getUIContext().getAttributeMap();
        attributeMap.put("componentName", this.componentName.getValue());
        attributeMap.put("instanceName", this.instanceName.getValue());
        attributeMap.put("targetPackage", this.targetPackage.getValue());
        attributeMap.put("className", this.className.getValue());
        attributeMap.put("kind", "cdi");
        return Results.navigateTo(ConfigureComponentPropertiesStep.class);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return Results.success();
    }

    protected String getDefaultProducerClassName() {
        String name = (String)this.instanceName.getValue();
        if (!Strings.isBlank((String)name)) {
            return Strings.capitalize((String)name) + "ComponentProducer";
        }
        return null;
    }
}

