/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.CamelEndpointDetails;
import io.fabric8.forge.camel.commands.project.ConfigureEditEndpointPropertiesStep;
import io.fabric8.forge.camel.commands.project.completer.XmlEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class CamelEditEndpointXmlCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    @Inject
    @WithAttributes(label="endpoints", required=true, description="The endpoints from the project")
    private UISelectOne<String> endpoints;
    @Inject
    private DependencyInstaller dependencyInstaller;
    @Inject
    private DependencyResolver dependencyResolver;
    private XmlEndpointsCompleter completer;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelEditEndpointXmlCommand.class).name("Camel: Edit Endpoint XML").category(Categories.create((String[])new String[]{CATEGORY})).description("Edit Camel endpoint from an existing XML file");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        boolean enabled = super.isEnabled(context);
        if (enabled) {
            boolean spring = CamelCommandsHelper.isSpringProject(this.getSelectedProject(context));
            boolean blueprint = CamelCommandsHelper.isBlueprintProject(this.getSelectedProject(context));
            return spring || blueprint;
        }
        return false;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject(builder.getUIContext());
        ResourcesFacet resourcesFacet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        this.completer = new XmlEndpointsCompleter(resourcesFacet, webResourcesFacet);
        this.endpoints.setValueChoices(this.completer.getEndpointUris());
        builder.add(this.endpoints);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        Map attributeMap = context.getUIContext().getAttributeMap();
        String selectedUri = (String)this.endpoints.getValue();
        CamelEndpointDetails detail = this.completer.getEndpointDetail(selectedUri);
        if (detail == null) {
            return null;
        }
        attributeMap.put("componentName", detail.getEndpointComponentName());
        attributeMap.put("instanceName", detail.getEndpointInstance());
        attributeMap.put("endpointUri", detail.getEndpointUri());
        attributeMap.put("lineNumber", detail.getLineNumber());
        attributeMap.put("xml", detail.getFileName());
        attributeMap.put("kind", "xml");
        return Results.navigateTo(ConfigureEditEndpointPropertiesStep.class);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        boolean empty;
        boolean bl = empty = !this.endpoints.getValueChoices().iterator().hasNext();
        if (empty) {
            return Results.fail((String)"No Camel endpoints found");
        }
        return Results.success();
    }
}

