/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.jolokia;

import io.fabric8.forge.camel.commands.jolokia.AbstractJolokiaCommand;
import javax.inject.Inject;
import org.apache.camel.commands.jolokia.DefaultJolokiaCamelController;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class ConnectCommand
extends AbstractJolokiaCommand {
    @Inject
    @WithAttributes(label="Url", required=true, description="url to remote jolokia agent", requiredMessage="You must provide an url to connect to the remote jolokia agent")
    private UIInput<String> url;
    @Inject
    @WithAttributes(label="Username", required=false, description="username for authentication")
    private UIInput<String> username;
    @Inject
    @WithAttributes(label="Password", required=false, description="password for authentication", type="org.jboss.forge.inputType.SECRET")
    private UIInput<String> password;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConnectCommand.class).name("camel-connect").category(Categories.create((String[])new String[]{CATEGORY})).description("Connects to a Jolokia agent");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        return !context.getProvider().isGUI();
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.url).add(this.username).add(this.password);
    }

    public Result execute(UIExecutionContext uiExecutionContext) throws Exception {
        this.configuration.setProperty("CamelJolokiaUrl", this.url.getValue());
        this.configuration.setProperty("CamelJolokiaUsername", this.username.getValue());
        this.configuration.setProperty("CamelJolokiaPassword", this.password.getValue());
        DefaultJolokiaCamelController controller = new DefaultJolokiaCamelController();
        controller.connect((String)this.url.getValue(), (String)this.username.getValue(), (String)this.password.getValue());
        boolean ok = controller.ping();
        if (ok) {
            return Results.success((String)("Connected to " + (String)this.url.getValue() + (this.username.getValue() != null ? " using " + (String)this.username.getValue() : "")));
        }
        return Results.fail((String)("Error connecting to " + (String)this.url.getValue()));
    }
}

