/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import io.fabric8.forge.addon.utils.XmlLineNumberParser;
import io.fabric8.forge.camel.commands.project.CamelEndpointDetails;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelXmlHelper;
import java.io.InputStream;
import java.util.List;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.visit.ResourceVisitor;
import org.jboss.forge.addon.resource.visit.VisitContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlResourcesCamelEndpointsVisitor
implements ResourceVisitor {
    private final ResourcesFacet facet;
    private final List<CamelEndpointDetails> endpoints;

    public XmlResourcesCamelEndpointsVisitor(ResourcesFacet facet, List<CamelEndpointDetails> endpoints) {
        this.facet = facet;
        this.endpoints = endpoints;
    }

    public void visit(VisitContext visitContext, Resource<?> resource) {
        boolean camel;
        String name = resource.getName();
        if (name.endsWith(".xml") && (camel = resource.getContents().contains("<camelContext"))) {
            try {
                Document dom = XmlLineNumberParser.parseXml((InputStream)resource.getResourceInputStream());
                if (dom != null) {
                    List<Node> nodes = CamelXmlHelper.findAllEndpoints(dom);
                    for (Node node : nodes) {
                        String uri = CamelXmlHelper.getSafeAttribute(node, "uri");
                        String id = CamelXmlHelper.getSafeAttribute(node, "id");
                        String lineNumber = (String)node.getUserData("lineNumber");
                        String baseDir = this.facet.getResourceDirectory().getFullyQualifiedName();
                        String fileName = resource.getFullyQualifiedName();
                        if (fileName.startsWith(baseDir)) {
                            fileName = fileName.substring(baseDir.length() + 1);
                        }
                        CamelEndpointDetails detail = new CamelEndpointDetails();
                        detail.setResource(resource);
                        detail.setFileName(fileName);
                        detail.setLineNumber(lineNumber);
                        detail.setEndpointInstance(id);
                        detail.setEndpointUri(uri);
                        detail.setEndpointComponentName(CamelCatalogHelper.endpointComponentName(uri));
                        this.endpoints.add(detail);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

