/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.helper;

import io.fabric8.forge.camel.commands.project.dto.ComponentDto;
import io.fabric8.forge.camel.commands.project.dto.DataFormatDto;
import io.fabric8.forge.camel.commands.project.dto.EipDto;
import io.fabric8.forge.camel.commands.project.dto.LanguageDto;
import io.fabric8.utils.Strings;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.JSonSchemaHelper;

public final class CamelCatalogHelper {
    public static String asTitleCase(String text) {
        StringBuilder sb = new StringBuilder();
        boolean next = true;
        for (char c : text.toCharArray()) {
            if (Character.isSpaceChar(c)) {
                next = true;
            } else if (next) {
                c = Character.toTitleCase(c);
                next = false;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String endpointComponentName(String uri) {
        int idx;
        if (uri != null && (idx = uri.indexOf(":")) > 0) {
            return uri.substring(0, idx);
        }
        return null;
    }

    public static Set<String> componentsFromArtifact(CamelCatalog camelCatalog, String artifactId) {
        TreeSet<String> answer = new TreeSet<String>();
        for (String name : camelCatalog.findComponentNames()) {
            String json = camelCatalog.componentJSonSchema(name);
            if (json == null) continue;
            List data = JSonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
            String scheme = null;
            String artifact = null;
            for (Map row : data) {
                if (row.get("artifactId") != null) {
                    artifact = (String)row.get("artifactId");
                }
                if (row.get("scheme") == null) continue;
                scheme = (String)row.get("scheme");
            }
            if (!artifactId.equals(artifact) || scheme == null) continue;
            answer.add(scheme);
        }
        return answer;
    }

    public static Set<String> dataFormatsFromArtifact(CamelCatalog camelCatalog, String artifactId) {
        TreeSet<String> answer = new TreeSet<String>();
        for (String name : camelCatalog.findDataFormatNames()) {
            String json = camelCatalog.dataFormatJSonSchema(name);
            if (json == null) continue;
            List data = JSonSchemaHelper.parseJsonSchema((String)"dataformat", (String)json, (boolean)false);
            String df = null;
            String artifact = null;
            for (Map row : data) {
                if (row.get("artifactId") != null) {
                    artifact = (String)row.get("artifactId");
                }
                if (row.get("name") == null) continue;
                df = (String)row.get("name");
            }
            if (!artifactId.equals(artifact) || df == null) continue;
            answer.add(df);
        }
        return answer;
    }

    public static Set<String> languagesFromArtifact(CamelCatalog camelCatalog, String artifactId) {
        TreeSet<String> answer = new TreeSet<String>();
        for (String name : camelCatalog.findLanguageNames()) {
            String json = camelCatalog.languageJSonSchema(name);
            if (json == null) continue;
            List data = JSonSchemaHelper.parseJsonSchema((String)"language", (String)json, (boolean)false);
            String lan = null;
            String artifact = null;
            for (Map row : data) {
                if (row.get("artifactId") != null) {
                    artifact = (String)row.get("artifactId");
                }
                if (row.get("name") == null) continue;
                lan = (String)row.get("name");
            }
            if (!artifactId.equals(artifact) || lan == null) continue;
            answer.add(lan);
        }
        return answer;
    }

    public static boolean isDefaultValue(CamelCatalog camelCatalog, String scheme, String key, String value) {
        String json = camelCatalog.componentJSonSchema(scheme);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + scheme);
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
        if (data != null) {
            for (Map propertyMap : data) {
                String name = (String)propertyMap.get("name");
                String defaultValue = (String)propertyMap.get("defaultValue");
                if (!key.equals(name)) continue;
                return value.equalsIgnoreCase(defaultValue);
            }
        }
        return false;
    }

    public static boolean isDefaultValueComponent(CamelCatalog camelCatalog, String scheme, String key, String value) {
        String json = camelCatalog.componentJSonSchema(scheme);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + scheme);
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"componentProperties", (String)json, (boolean)true);
        if (data != null) {
            for (Map propertyMap : data) {
                String name = (String)propertyMap.get("name");
                String defaultValue = (String)propertyMap.get("defaultValue");
                if (!key.equals(name)) continue;
                return value.equalsIgnoreCase(defaultValue);
            }
        }
        return false;
    }

    public static boolean isMultiValue(CamelCatalog camelCatalog, String scheme, String key) {
        String json = camelCatalog.componentJSonSchema(scheme);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + scheme);
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
        if (data != null) {
            for (Map propertyMap : data) {
                String name = (String)propertyMap.get("name");
                String multiValue = (String)propertyMap.get("multiValue");
                if (!key.equals(name)) continue;
                return "true".equals(multiValue);
            }
        }
        return false;
    }

    public static String getPrefix(CamelCatalog camelCatalog, String scheme, String key) {
        String json = camelCatalog.componentJSonSchema(scheme);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + scheme);
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
        if (data != null) {
            for (Map propertyMap : data) {
                String name = (String)propertyMap.get("name");
                String prefix = (String)propertyMap.get("prefix");
                if (!key.equals(name)) continue;
                return prefix;
            }
        }
        return null;
    }

    public static boolean isNonePlaceholderEnumValue(CamelCatalog camelCatalog, String scheme, String key) {
        String json = camelCatalog.componentJSonSchema(scheme);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + scheme);
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
        if (data != null) {
            for (Map propertyMap : data) {
                String name = (String)propertyMap.get("name");
                String enums = (String)propertyMap.get("enum");
                if (!key.equals(name) || enums == null) continue;
                return !enums.contains("none");
            }
        }
        return false;
    }

    public static boolean isNonePlaceholderEnumValueComponent(CamelCatalog camelCatalog, String scheme, String key) {
        String json = camelCatalog.componentJSonSchema(scheme);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + scheme);
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"componentProperties", (String)json, (boolean)true);
        if (data != null) {
            for (Map propertyMap : data) {
                String name = (String)propertyMap.get("name");
                String enums = (String)propertyMap.get("enum");
                if (!key.equals(name) || enums == null) continue;
                return !enums.contains("none");
            }
        }
        return false;
    }

    public static String getEnumJavaTypeComponent(CamelCatalog camelCatalog, String scheme, String key) {
        String json = camelCatalog.componentJSonSchema(scheme);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + scheme);
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"componentProperties", (String)json, (boolean)true);
        if (data != null) {
            for (Map propertyMap : data) {
                String javaType = (String)propertyMap.get("javaType");
                String name = (String)propertyMap.get("name");
                String enums = (String)propertyMap.get("enum");
                if (!key.equals(name) || enums == null) continue;
                return javaType;
            }
        }
        return null;
    }

    public static boolean isModelDefaultValue(CamelCatalog camelCatalog, String modelName, String key, String value) {
        String json = camelCatalog.modelJSonSchema(modelName);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for model name: " + modelName);
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
        if (data != null) {
            for (Map propertyMap : data) {
                String name = (String)propertyMap.get("name");
                String defaultValue = (String)propertyMap.get("defaultValue");
                if (!key.equals(name)) continue;
                return value.equalsIgnoreCase(defaultValue);
            }
        }
        return false;
    }

    public static boolean isModelExpressionKind(CamelCatalog camelCatalog, String modelName, String key) {
        String json = camelCatalog.modelJSonSchema(modelName);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for model name: " + modelName);
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
        if (data != null) {
            for (Map propertyMap : data) {
                String name = (String)propertyMap.get("name");
                if (!key.equals(name)) continue;
                return "expression".equals(propertyMap.get("kind"));
            }
        }
        return false;
    }

    public static String getModelJavaType(CamelCatalog camelCatalog, String modelName) {
        String json = camelCatalog.modelJSonSchema(modelName);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for model name: " + modelName);
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"model", (String)json, (boolean)false);
        if (data != null) {
            for (Map propertyMap : data) {
                String javaType = (String)propertyMap.get("javaType");
                if (javaType == null) continue;
                return javaType;
            }
        }
        return null;
    }

    public static boolean isModelSupportOutput(CamelCatalog camelCatalog, String modelName) {
        String json = camelCatalog.modelJSonSchema(modelName);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for model name: " + modelName);
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"model", (String)json, (boolean)false);
        if (data != null) {
            for (Map propertyMap : data) {
                String output = (String)propertyMap.get("output");
                if (output == null) continue;
                return "true".equals(output);
            }
        }
        return false;
    }

    public static boolean isComponentConsumerOnly(CamelCatalog camelCatalog, String scheme) {
        String json = camelCatalog.componentJSonSchema(scheme);
        if (json == null) {
            return false;
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
        if (data != null) {
            for (Map propertyMap : data) {
                String consumerOnly = (String)propertyMap.get("consumerOnly");
                if (consumerOnly == null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isComponentProducerOnly(CamelCatalog camelCatalog, String scheme) {
        String json = camelCatalog.componentJSonSchema(scheme);
        if (json == null) {
            return false;
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
        if (data != null) {
            for (Map propertyMap : data) {
                String consumerOnly = (String)propertyMap.get("producerOnly");
                if (consumerOnly == null) continue;
                return true;
            }
        }
        return false;
    }

    public static ComponentDto createComponentDto(CamelCatalog camelCatalog, String scheme) {
        String json = camelCatalog.componentJSonSchema(scheme);
        if (json == null) {
            return null;
        }
        ComponentDto dto = new ComponentDto();
        List data = JSonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
        for (Map row : data) {
            if (row.get("scheme") != null) {
                dto.setScheme((String)row.get("scheme"));
                continue;
            }
            if (row.get("syntax") != null) {
                dto.setSyntax((String)row.get("syntax"));
                continue;
            }
            if (row.get("title") != null) {
                dto.setTitle((String)row.get("title"));
                continue;
            }
            if (row.get("description") != null) {
                dto.setDescription((String)row.get("description"));
                continue;
            }
            if (row.get("label") != null) {
                String labelText = (String)row.get("label");
                if (!Strings.isNotBlank((String)labelText)) continue;
                dto.setTags(labelText.split(","));
                continue;
            }
            if (row.get("consumerOnly") != null) {
                dto.setConsumerOnly("true".equals(row.get("consumerOnly")));
                continue;
            }
            if (row.get("producerOnly") != null) {
                dto.setProducerOnly("true".equals(row.get("producerOnly")));
                continue;
            }
            if (row.get("javaType") != null) {
                dto.setJavaType((String)row.get("javaType"));
                continue;
            }
            if (row.get("groupId") != null) {
                dto.setGroupId((String)row.get("groupId"));
                continue;
            }
            if (row.get("artifactId") != null) {
                dto.setArtifactId((String)row.get("artifactId"));
                continue;
            }
            if (row.get("version") == null) continue;
            dto.setVersion((String)row.get("version"));
        }
        return dto;
    }

    public static EipDto createEipDto(CamelCatalog camelCatalog, String modelName) {
        String json = camelCatalog.modelJSonSchema(modelName);
        if (json == null) {
            return null;
        }
        EipDto dto = new EipDto();
        List data = JSonSchemaHelper.parseJsonSchema((String)"model", (String)json, (boolean)false);
        for (Map row : data) {
            if (row.get("name") != null) {
                dto.setName((String)row.get("name"));
                continue;
            }
            if (row.get("title") != null) {
                dto.setTitle((String)row.get("title"));
                continue;
            }
            if (row.get("description") != null) {
                dto.setDescription((String)row.get("description"));
                continue;
            }
            if (row.get("label") != null) {
                String labelText = (String)row.get("label");
                if (!Strings.isNotBlank((String)labelText)) continue;
                dto.setTags(labelText.split(","));
                continue;
            }
            if (row.get("javaType") == null) continue;
            dto.setJavaType((String)row.get("javaType"));
        }
        return dto;
    }

    public static DataFormatDto createDataFormatDto(CamelCatalog camelCatalog, String name) {
        String json = camelCatalog.dataFormatJSonSchema(name);
        if (json == null) {
            return null;
        }
        DataFormatDto dto = new DataFormatDto();
        List data = JSonSchemaHelper.parseJsonSchema((String)"dataformat", (String)json, (boolean)false);
        for (Map row : data) {
            if (row.get("name") != null) {
                dto.setName((String)row.get("name"));
                continue;
            }
            if (row.get("modelName") != null) {
                dto.setModelName((String)row.get("modelName"));
                continue;
            }
            if (row.get("title") != null) {
                dto.setTitle((String)row.get("title"));
                continue;
            }
            if (row.get("description") != null) {
                dto.setDescription((String)row.get("description"));
                continue;
            }
            if (row.get("label") != null) {
                dto.setLabel((String)row.get("label"));
                continue;
            }
            if (row.get("javaType") != null) {
                dto.setJavaType((String)row.get("javaType"));
                continue;
            }
            if (row.get("modelJavaType") != null) {
                dto.setModelJavaType((String)row.get("modelJavaType"));
                continue;
            }
            if (row.get("groupId") != null) {
                dto.setGroupId((String)row.get("groupId"));
                continue;
            }
            if (row.get("artifactId") != null) {
                dto.setArtifactId((String)row.get("artifactId"));
                continue;
            }
            if (row.get("version") == null) continue;
            dto.setVersion((String)row.get("version"));
        }
        return dto;
    }

    public static LanguageDto createLanguageDto(CamelCatalog camelCatalog, String name) {
        String json;
        if ("method".equals(name)) {
            name = "bean";
        }
        if ((json = camelCatalog.languageJSonSchema(name)) == null) {
            return null;
        }
        LanguageDto dto = new LanguageDto();
        List data = JSonSchemaHelper.parseJsonSchema((String)"language", (String)json, (boolean)false);
        for (Map row : data) {
            if (row.get("name") != null) {
                dto.setName((String)row.get("name"));
                continue;
            }
            if (row.get("modelName") != null) {
                dto.setModelName((String)row.get("modelName"));
                continue;
            }
            if (row.get("title") != null) {
                dto.setTitle((String)row.get("title"));
                continue;
            }
            if (row.get("description") != null) {
                dto.setDescription((String)row.get("description"));
                continue;
            }
            if (row.get("label") != null) {
                dto.setLabel((String)row.get("label"));
                continue;
            }
            if (row.get("javaType") != null) {
                dto.setJavaType((String)row.get("javaType"));
                continue;
            }
            if (row.get("modelJavaType") != null) {
                dto.setModelJavaType((String)row.get("modelJavaType"));
                continue;
            }
            if (row.get("groupId") != null) {
                dto.setGroupId((String)row.get("groupId"));
                continue;
            }
            if (row.get("artifactId") != null) {
                dto.setArtifactId((String)row.get("artifactId"));
                continue;
            }
            if (row.get("version") == null) continue;
            dto.setVersion((String)row.get("version"));
        }
        return dto;
    }
}

