/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.LineNumberHelper;
import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.ConfigureEndpointPropertiesStep;
import io.fabric8.forge.camel.commands.project.dto.ComponentDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.helper.PoorMansLogger;
import io.fabric8.forge.camel.commands.project.model.InputOptionByGroup;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class CamelAddEndpointCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    private static final int MAX_OPTIONS = 20;
    private static final PoorMansLogger LOG = new PoorMansLogger(false);
    @Inject
    @WithAttributes(label="Name", required=true, description="Name of component to use for the endpoint")
    private UISelectOne<ComponentDto> componentName;
    @Inject
    private InputComponentFactory componentFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelAddEndpointCommand.class).name("Camel: Add Endpoint").category(Categories.create((String[])new String[]{CATEGORY})).description("Add Camel endpoint to the current file");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        boolean answer = super.isEnabled(context);
        if (answer && this.isRunningInGui(context)) {
            int pos = this.getCurrentCursorPosition(context);
            answer = pos > -1;
        }
        return answer;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Map attributeMap = builder.getUIContext().getAttributeMap();
        attributeMap.remove("navigationResult");
        Project project = this.getSelectedProject(builder.getUIContext());
        String selectedFile = this.getSelectedFile(builder.getUIContext());
        String currentFile = this.asRelativeFile(builder.getUIContext(), selectedFile);
        attributeMap.put("currentFile", currentFile);
        boolean xmlFile = this.isSelectedFileXml(builder.getUIContext());
        AtomicBoolean consumerOnly = new AtomicBoolean();
        AtomicBoolean producerOnly = new AtomicBoolean();
        this.determineConsumerAndProducerOnly(consumerOnly, producerOnly, builder.getUIContext(), xmlFile, currentFile);
        attributeMap.put("consumerOnly", Boolean.toString(consumerOnly.get()));
        attributeMap.put("producerOnly", Boolean.toString(producerOnly.get()));
        this.configureComponentName(project, this.componentName, consumerOnly.get(), producerOnly.get());
        builder.add(this.componentName);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        NavigationResult navigationResult;
        Map attributeMap = context.getUIContext().getAttributeMap();
        ComponentDto component = (ComponentDto)this.componentName.getValue();
        String camelComponentName = component.getScheme();
        String previous = (String)attributeMap.get("componentName");
        if (previous != null && previous.equals(camelComponentName) && (navigationResult = (NavigationResult)attributeMap.get("navigationResult")) != null) {
            return navigationResult;
        }
        attributeMap.put("componentName", camelComponentName);
        String currentFile = (String)attributeMap.get("currentFile");
        boolean xmlFile = currentFile != null && currentFile.endsWith(".xml");
        boolean javaFile = currentFile != null && currentFile.endsWith(".java");
        attributeMap.put("mode", "add");
        if (xmlFile) {
            attributeMap.put("xml", currentFile);
            attributeMap.put("kind", "xml");
        } else if (javaFile) {
            attributeMap.put("routeBuilder", currentFile);
            attributeMap.put("kind", "java");
        } else {
            attributeMap.put("currentFile", currentFile);
            attributeMap.put("kind", "other");
        }
        int pos = this.getCurrentCursorPosition(context.getUIContext());
        attributeMap.put("cursorPosition", pos);
        boolean consumerOnly = "true".equals(attributeMap.get("consumerOnly"));
        boolean producerOnly = "true".equals(attributeMap.get("producerOnly"));
        UIContext ui = context.getUIContext();
        List<InputOptionByGroup> groups = CamelCommandsHelper.createUIInputsForCamelEndpoint(camelComponentName, null, 20, consumerOnly, producerOnly, this.getCamelCatalog(), this.componentFactory, this.converterFactory, ui);
        ArrayList<InputComponent> allInputs = new ArrayList<InputComponent>();
        for (InputOptionByGroup group : groups) {
            allInputs.addAll(group.getInputs());
        }
        NavigationResultBuilder builder = Results.navigationBuilder();
        int pages = groups.size();
        for (int i = 0; i < pages; ++i) {
            boolean last = i == pages - 1;
            InputOptionByGroup current = groups.get(i);
            ConfigureEndpointPropertiesStep step = new ConfigureEndpointPropertiesStep(this.projectFactory, this.dependencyInstaller, this.getCamelCatalog(), camelComponentName, current.getGroup(), allInputs, current.getInputs(), last, i, pages);
            builder.add((UICommand)step);
        }
        NavigationResult navigationResult2 = builder.build();
        attributeMap.put("navigationResult", navigationResult2);
        return navigationResult2;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return null;
    }

    private void determineConsumerAndProducerOnly(AtomicBoolean consumerOnly, AtomicBoolean producerOnly, UIContext context, boolean xmlFile, String currentFile) {
        block20: {
            Project project = this.getSelectedProject(context);
            int cursorLineNumber = this.getCurrentCursorLine(context);
            if (cursorLineNumber == -1) {
                return;
            }
            if (xmlFile) {
                FileResource file;
                ResourcesFacet facet = null;
                if (project.hasFacet(ResourcesFacet.class)) {
                    facet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
                }
                WebResourcesFacet webResourcesFacet = null;
                if (project.hasFacet(WebResourcesFacet.class)) {
                    webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
                }
                FileResource fileResource = file = facet != null ? facet.getResource(currentFile) : null;
                if (file == null || !file.exists()) {
                    file = webResourcesFacet != null ? webResourcesFacet.getWebResource(currentFile) : null;
                }
                try {
                    if (file == null || !file.exists() || cursorLineNumber <= 0) break block20;
                    List lines = LineNumberHelper.readLines((InputStream)file.getResourceInputStream());
                    String line = (String)lines.get(cursorLineNumber - 1);
                    LOG.info("Line " + line);
                    if (line != null) {
                        if (line.contains("<from") || line.contains("<pollEnrich")) {
                            consumerOnly.set(true);
                        } else if (!line.contains("<endpoint")) {
                            producerOnly.set(true);
                        }
                    }
                }
                catch (Exception lines) {}
            } else {
                JavaSourceFacet facet = null;
                if (project.hasFacet(JavaSourceFacet.class)) {
                    facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
                }
                JavaResource file = facet != null ? facet.getJavaResource(currentFile) : null;
                try {
                    if (file != null && file.exists() && cursorLineNumber > 0) {
                        List lines = LineNumberHelper.readLines((InputStream)file.getResourceInputStream());
                        String line = (String)lines.get(cursorLineNumber - 1);
                        LOG.info("Line " + line);
                        if (line != null) {
                            if (line.contains("from(") || line.contains("pollEnrich(")) {
                                consumerOnly.set(true);
                            } else if (!line.contains("endpoint(")) {
                                producerOnly.set(true);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

