/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.CamelProjectAddComponentStep;
import io.fabric8.forge.camel.commands.project.dto.ComponentDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import javax.inject.Inject;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class CamelProjectAddComponentCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    @Inject
    @WithAttributes(label="Filter", required=true, description="To filter components")
    private UISelectOne<String> filter;
    @Inject
    @WithAttributes(label="Name", required=true, description="Name of component type to add")
    private UISelectOne<ComponentDto> componentName;
    @Inject
    private DependencyInstaller dependencyInstaller;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelProjectAddComponentCommand.class).name("Camel: Project Add Component").category(Categories.create((String[])new String[]{CATEGORY})).description("Adds a Camel component to your project dependencies");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)builder);
        this.filter.setValueChoices(CamelCommandsHelper.createComponentLabelValues(project, this.getCamelCatalog()));
        this.filter.setDefaultValue((Object)"<all>");
        builder.add(this.filter);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        NavigationResultBuilder builder = Results.navigationBuilder();
        builder.add((UICommand)new CamelProjectAddComponentStep(this.filter, this.componentName, this.projectFactory, this.dependencyInstaller, this.getCamelCatalog()));
        return builder.build();
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return null;
    }
}

